/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.render;

import com.mojang.blaze3d.pipeline.BlendFunction;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.platform.DepthTestFunction;
import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.block.BlockShape;
import java.util.OptionalDouble;
import net.minecraft.class_10799;
import net.minecraft.class_1921;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_265;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4668;
import org.joml.Matrix4f;

public class RenderUtils {
    private static final class_1921 LINES = class_1921.method_24049((String)"supermartijn642corelib:lines", (int)128, (boolean)true, (boolean)true, (RenderPipeline)RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{class_10799.field_56859}).withLocation(class_2960.method_60655((String)"supermartijn642corelib", (String)"lines")).withBlend(BlendFunction.TRANSLUCENT).withCull(false).withDepthTestFunction(DepthTestFunction.LEQUAL_DEPTH_TEST).build(), (class_1921.class_4688)class_1921.class_4688.method_23598().method_23609(new class_4668.class_4677(OptionalDouble.of(1.0))).method_23607(class_4668.field_22241).method_23617(false));
    private static final class_1921 LINES_NO_DEPTH = class_1921.method_24049((String)"supermartijn642corelib:lines_no_depth", (int)128, (boolean)true, (boolean)true, (RenderPipeline)RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{class_10799.field_56859}).withLocation(class_2960.method_60655((String)"supermartijn642corelib", (String)"lines_no_depth")).withBlend(BlendFunction.TRANSLUCENT).withCull(false).withDepthTestFunction(DepthTestFunction.NO_DEPTH_TEST).build(), (class_1921.class_4688)class_1921.class_4688.method_23598().method_23609(new class_4668.class_4677(OptionalDouble.of(1.0))).method_23607(class_4668.field_22241).method_23617(false));
    private static final class_1921 QUADS = class_1921.method_24049((String)"supermartijn642corelib:quads", (int)256, (boolean)false, (boolean)true, (RenderPipeline)RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{class_10799.field_56860}).withLocation(class_2960.method_60655((String)"supermartijn642corelib", (String)"quads")).withBlend(BlendFunction.TRANSLUCENT).withCull(false).withDepthTestFunction(DepthTestFunction.LEQUAL_DEPTH_TEST).withDepthWrite(false).build(), (class_1921.class_4688)class_1921.class_4688.method_23598().method_23617(false));
    private static final class_1921 QUADS_NO_DEPTH = class_1921.method_24049((String)"supermartijn642corelib:quads_no_depth", (int)256, (boolean)false, (boolean)true, (RenderPipeline)RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{class_10799.field_56860}).withLocation(class_2960.method_60655((String)"supermartijn642corelib", (String)"quads_no_depth")).withBlend(BlendFunction.TRANSLUCENT).withCull(false).withDepthTestFunction(DepthTestFunction.NO_DEPTH_TEST).withDepthWrite(false).build(), (class_1921.class_4688)class_1921.class_4688.method_23598().method_23617(false));
    public static final ThreadLocal<class_4597.class_4598> GUI_BUFFER_SOURCE_OVERWRITE = new ThreadLocal();

    public static class_243 getCameraPosition() {
        return ClientUtils.getMinecraft().method_1561().field_4686.method_19326();
    }

    public static class_4597.class_4598 getMainBufferSource() {
        class_4597.class_4598 bufferSource = GUI_BUFFER_SOURCE_OVERWRITE.get();
        if (bufferSource != null) {
            return bufferSource;
        }
        return ClientUtils.getMinecraft().method_22940().method_23000();
    }

    public static void renderShape(class_4587 poseStack, BlockShape shape, float red, float green, float blue, float alpha, boolean depthTest) {
        class_1921 renderType = depthTest ? LINES : LINES_NO_DEPTH;
        class_4597.class_4598 bufferSource = RenderUtils.getMainBufferSource();
        class_4588 builder = bufferSource.getBuffer(renderType);
        class_4587.class_4665 pose = poseStack.method_23760();
        Matrix4f matrix = pose.method_23761();
        shape.forEachEdge((x1, y1, z1, x2, y2, z2) -> {
            class_243 normal = new class_243(x2 - x1, y2 - y1, z2 - z1);
            normal.method_1029();
            builder.method_22918(matrix, (float)x1, (float)y1, (float)z1).method_22915(red, green, blue, alpha).method_60831(pose, (float)normal.field_1352, (float)normal.field_1351, (float)normal.field_1350);
            builder.method_22918(matrix, (float)x2, (float)y2, (float)z2).method_22915(red, green, blue, alpha).method_60831(pose, (float)normal.field_1352, (float)normal.field_1351, (float)normal.field_1350);
        });
        bufferSource.method_22994(renderType);
    }

    public static void renderShapeSides(class_4587 poseStack, BlockShape shape, float red, float green, float blue, float alpha, boolean depthTest) {
        class_1921 renderType = depthTest ? QUADS : QUADS_NO_DEPTH;
        class_4597.class_4598 bufferSource = RenderUtils.getMainBufferSource();
        class_4588 builder = bufferSource.getBuffer(renderType);
        Matrix4f matrix = poseStack.method_23760().method_23761();
        shape.forEachBox(box -> {
            float minX = (float)box.field_1323;
            float maxX = (float)box.field_1320;
            float minY = (float)box.field_1322;
            float maxY = (float)box.field_1325;
            float minZ = (float)box.field_1321;
            float maxZ = (float)box.field_1324;
            builder.method_22918(matrix, minX, minY, minZ).method_22915(red, green, blue, alpha);
            builder.method_22918(matrix, minX, maxY, minZ).method_22915(red, green, blue, alpha);
            builder.method_22918(matrix, maxX, maxY, minZ).method_22915(red, green, blue, alpha);
            builder.method_22918(matrix, maxX, minY, minZ).method_22915(red, green, blue, alpha);
            builder.method_22918(matrix, minX, minY, maxZ).method_22915(red, green, blue, alpha);
            builder.method_22918(matrix, maxX, minY, maxZ).method_22915(red, green, blue, alpha);
            builder.method_22918(matrix, maxX, maxY, maxZ).method_22915(red, green, blue, alpha);
            builder.method_22918(matrix, minX, maxY, maxZ).method_22915(red, green, blue, alpha);
            builder.method_22918(matrix, minX, minY, minZ).method_22915(red, green, blue, alpha);
            builder.method_22918(matrix, maxX, minY, minZ).method_22915(red, green, blue, alpha);
            builder.method_22918(matrix, maxX, minY, maxZ).method_22915(red, green, blue, alpha);
            builder.method_22918(matrix, minX, minY, maxZ).method_22915(red, green, blue, alpha);
            builder.method_22918(matrix, minX, maxY, minZ).method_22915(red, green, blue, alpha);
            builder.method_22918(matrix, minX, maxY, maxZ).method_22915(red, green, blue, alpha);
            builder.method_22918(matrix, maxX, maxY, maxZ).method_22915(red, green, blue, alpha);
            builder.method_22918(matrix, maxX, maxY, minZ).method_22915(red, green, blue, alpha);
            builder.method_22918(matrix, minX, minY, minZ).method_22915(red, green, blue, alpha);
            builder.method_22918(matrix, minX, minY, maxZ).method_22915(red, green, blue, alpha);
            builder.method_22918(matrix, minX, maxY, maxZ).method_22915(red, green, blue, alpha);
            builder.method_22918(matrix, minX, maxY, minZ).method_22915(red, green, blue, alpha);
            builder.method_22918(matrix, maxX, minY, minZ).method_22915(red, green, blue, alpha);
            builder.method_22918(matrix, maxX, maxY, minZ).method_22915(red, green, blue, alpha);
            builder.method_22918(matrix, maxX, maxY, maxZ).method_22915(red, green, blue, alpha);
            builder.method_22918(matrix, maxX, minY, maxZ).method_22915(red, green, blue, alpha);
        });
        bufferSource.method_22994(renderType);
    }

    public static void renderShape(class_4587 poseStack, class_265 shape, float red, float green, float blue, float alpha, boolean depthTest) {
        RenderUtils.renderShape(poseStack, BlockShape.create(shape), red, green, blue, alpha, depthTest);
    }

    public static void renderShapeSides(class_4587 poseStack, class_265 shape, float red, float green, float blue, float alpha, boolean depthTest) {
        RenderUtils.renderShapeSides(poseStack, BlockShape.create(shape), red, green, blue, alpha, depthTest);
    }

    public static void renderBox(class_4587 poseStack, class_238 box, float red, float green, float blue, float alpha, boolean depthTest) {
        RenderUtils.renderShape(poseStack, BlockShape.create(box), red, green, blue, alpha, depthTest);
    }

    public static void renderBoxSides(class_4587 poseStack, class_238 box, float red, float green, float blue, float alpha, boolean depthTest) {
        RenderUtils.renderShapeSides(poseStack, BlockShape.create(box), red, green, blue, alpha, depthTest);
    }

    public static void renderShape(class_4587 poseStack, BlockShape shape, float red, float green, float blue, boolean depthTest) {
        RenderUtils.renderShape(poseStack, shape, red, green, blue, 1.0f, depthTest);
    }

    public static void renderShapeSides(class_4587 poseStack, BlockShape shape, float red, float green, float blue, boolean depthTest) {
        RenderUtils.renderShapeSides(poseStack, shape, red, green, blue, 1.0f, depthTest);
    }

    public static void renderShape(class_4587 poseStack, class_265 shape, float red, float green, float blue, boolean depthTest) {
        RenderUtils.renderShape(poseStack, BlockShape.create(shape), red, green, blue, 1.0f, depthTest);
    }

    public static void renderShapeSides(class_4587 poseStack, class_265 shape, float red, float green, float blue, boolean depthTest) {
        RenderUtils.renderShapeSides(poseStack, BlockShape.create(shape), red, green, blue, 1.0f, depthTest);
    }

    public static void renderBox(class_4587 poseStack, class_238 box, float red, float green, float blue, boolean depthTest) {
        RenderUtils.renderShape(poseStack, BlockShape.create(box), red, green, blue, 1.0f, depthTest);
    }

    public static void renderBoxSides(class_4587 poseStack, class_238 box, float red, float green, float blue, boolean depthTest) {
        RenderUtils.renderShapeSides(poseStack, BlockShape.create(box), red, green, blue, 1.0f, depthTest);
    }
}

