/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.gui;

import com.mojang.blaze3d.buffers.GpuBufferSlice;
import com.mojang.blaze3d.systems.GpuDevice;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.FilterMode;
import com.mojang.blaze3d.textures.GpuTexture;
import com.mojang.blaze3d.textures.GpuTextureView;
import com.mojang.blaze3d.textures.TextureFormat;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.class_10366;
import net.minecraft.class_10799;
import net.minecraft.class_11231;
import net.minecraft.class_11239;
import net.minecraft.class_11241;
import net.minecraft.class_11246;
import net.minecraft.class_11256;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_8030;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix3x2f;

public class ArbitraryPictureInPictureRenderer
extends class_11239<State> {
    private final class_4587 poseStack = new class_4587();
    private final List<TextureEntry> textures = new ArrayList<TextureEntry>();
    private final BitSet inUse = new BitSet();

    public ArbitraryPictureInPictureRenderer(class_4597.class_4598 bufferSource) {
        super(bufferSource);
    }

    public Class<State> method_70903() {
        return State.class;
    }

    public void prepare(State state, class_11246 guiRenderState, int guiScale) {
        int width = state.width * guiScale;
        int height = state.height * guiScale;
        TextureEntry texture = null;
        int textureIndex = 0;
        while ((textureIndex = this.inUse.nextClearBit(textureIndex)) < this.textures.size()) {
            TextureEntry entry = this.textures.get(textureIndex);
            if (entry.width >= width && entry.height >= height) {
                texture = entry;
                break;
            }
            ++textureIndex;
        }
        if (texture == null) {
            texture = this.createTexture(width, height);
            this.textures.add(texture);
        }
        this.inUse.set(textureIndex);
        RenderSystem.getDevice().createCommandEncoder().clearColorAndDepthTextures(texture.texture, 0, texture.depthTexture, 1.0);
        RenderSystem.setProjectionMatrix((GpuBufferSlice)this.field_60042.method_71092((float)texture.width, (float)texture.height), (class_10366)class_10366.field_54954);
        RenderSystem.outputColorTextureOverride = texture.textureView;
        RenderSystem.outputDepthTextureOverride = texture.depthTextureView;
        this.poseStack.method_22903();
        this.poseStack.method_22905((float)guiScale, (float)guiScale, (float)(-guiScale));
        this.renderToTexture(state, this.poseStack);
        this.poseStack.method_22909();
        this.field_59933.method_22993();
        RenderSystem.outputColorTextureOverride = null;
        RenderSystem.outputDepthTextureOverride = null;
        guiRenderState.method_71996(new class_11241(class_10799.field_59968, class_11231.method_70900((GpuTextureView)texture.textureView), state.method_72127(), state.comp_4122(), state.comp_4123(), state.comp_4124(), state.comp_4125(), 0.0f, (float)width / (float)texture.width, 1.0f, 1.0f - (float)height / (float)texture.height, -1, state.comp_4128(), state.comp_4274()));
    }

    private TextureEntry createTexture(int width, int height) {
        GpuDevice device = RenderSystem.getDevice();
        GpuTexture texture = device.createTexture(this::method_70906, 12, TextureFormat.RGBA8, width, height, 1, 1);
        texture.setTextureFilter(FilterMode.NEAREST, false);
        GpuTextureView textureView = device.createTextureView(texture);
        GpuTexture depthTexture = device.createTexture(() -> this.method_70906() + " depth texture", 8, TextureFormat.DEPTH32, width, height, 1, 1);
        GpuTextureView depthTextureView = device.createTextureView(depthTexture);
        return new TextureEntry(width, height, texture, textureView, depthTexture, depthTextureView);
    }

    public void afterFrame() {
        if (this.textures.isEmpty()) {
            return;
        }
        int index = this.textures.size() - 1;
        while ((index = this.inUse.previousClearBit(index)) != -1) {
            this.textures.remove(index).close();
            --index;
        }
        this.inUse.clear();
        this.textures.sort(TextureEntry::compareTo);
    }

    protected void renderToTexture(State state, class_4587 poseStack) {
        try {
            state.rendering.accept(poseStack, this.field_59933);
        }
        catch (Exception e) {
            throw new RuntimeException("Encountered an exception whilst rendering picture in picture element!", e);
        }
    }

    protected String method_70906() {
        return "SuperMartijn642's Core Library custom picture in picture rendering";
    }

    public void close() {
        super.close();
        this.textures.forEach(TextureEntry::close);
        this.textures.clear();
        this.inUse.clear();
    }

    public static final class State
    extends Record
    implements class_11256 {
        private final int x;
        private final int y;
        private final int width;
        private final int height;
        private final Matrix3x2f pose;
        private final BiConsumer<class_4587, class_4597.class_4598> rendering;

        public State(int x, int y, int width, int height, Matrix3x2f pose, BiConsumer<class_4587, class_4597.class_4598> rendering) {
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
            this.pose = pose;
            this.rendering = rendering;
        }

        public int comp_4122() {
            return this.x;
        }

        public int comp_4124() {
            return this.x + this.width;
        }

        public int comp_4123() {
            return this.y;
        }

        public int comp_4125() {
            return this.y + this.height;
        }

        public float comp_4133() {
            return 1.0f;
        }

        public class_8030 comp_4128() {
            return null;
        }

        public class_8030 comp_4274() {
            return new class_8030(this.x, this.y, this.width, this.height);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{State.class, "x;y;width;height;pose;rendering", "x", "y", "width", "height", "pose", "rendering"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{State.class, "x;y;width;height;pose;rendering", "x", "y", "width", "height", "pose", "rendering"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{State.class, "x;y;width;height;pose;rendering", "x", "y", "width", "height", "pose", "rendering"}, this, o);
        }

        public int x() {
            return this.x;
        }

        public int y() {
            return this.y;
        }

        public int width() {
            return this.width;
        }

        public int height() {
            return this.height;
        }

        public Matrix3x2f method_72127() {
            return this.pose;
        }

        public BiConsumer<class_4587, class_4597.class_4598> rendering() {
            return this.rendering;
        }
    }

    private record TextureEntry(int width, int height, GpuTexture texture, GpuTextureView textureView, GpuTexture depthTexture, GpuTextureView depthTextureView) implements Comparable<TextureEntry>
    {
        public void close() {
            this.texture.close();
            this.textureView.close();
            this.depthTexture.close();
            this.depthTextureView.close();
        }

        @Override
        public int compareTo(@NotNull TextureEntry o) {
            return Integer.compare(this.width * this.height, o.width * o.height);
        }
    }
}

