/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.tcdcommons.api.util.collections;

import io.github.thecsdev.tcdcommons.api.util.annotations.Virtual;
import java.util.HashMap;
import org.jetbrains.annotations.Nullable;

@Virtual
public class GenericProperties<K>
extends HashMap<K, Object> {
    private static final long serialVersionUID = 7086758792901773483L;

    @Nullable
    public final <V> V getProperty(K key) throws ClassCastException {
        return this.get(key);
    }

    @Nullable
    public final <V> V getProperty(K key, V defaultValue) throws ClassCastException {
        V val = this.getProperty(key);
        return val != null ? val : defaultValue;
    }

    @Nullable
    public final <V> V getPropertyOrDefault(K key, V defaultValue) {
        V val = null;
        try {
            val = this.getProperty(key);
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        if (val == null) {
            Object[] objectArray = new Object[1];
            V v = defaultValue;
            val = v;
            objectArray[0] = v;
            this.setProperty(key, objectArray);
        }
        return val;
    }

    @SafeVarargs
    @Nullable
    public final <V> V setProperty(K key, V ... value) throws IllegalArgumentException {
        if (value == null || value.length != 1) {
            throw new IllegalArgumentException("value");
        }
        V prev = this.put(key, value[0]);
        return (V)(value.getClass().getComponentType().isInstance(prev) ? prev : null);
    }
}

