/*
 * Decompiled with CFR 0.152.
 */
package bre2el.fpsreducer.handler;

import bre2el.fpsreducer.config.Config;
import bre2el.fpsreducer.handler.GuiOpenEventHandler;
import bre2el.fpsreducer.handler.glfw.InputEventHandler;
import bre2el.fpsreducer.util.GlfwUtils;
import bre2el.fpsreducer.util.Logger;
import net.minecraft.class_310;
import net.minecraft.class_315;
import net.minecraft.class_3419;
import net.minecraft.class_9919;
import net.minecraft.class_9927;
import org.lwjgl.glfw.GLFW;

public class WakeupEventHandler {
    public static WakeupEventHandler INSTANCE = new WakeupEventHandler();
    private class_310 mc = class_310.method_1551();
    private long windowHandle = this.mc.method_22683().method_4490();
    private int maxFPS;
    private long idleStartTime;
    private float currentGameSettingVolume;
    private boolean stopSound = false;
    public int fpsMode;
    public static final int MODE_IDLE = 0;
    public static final int MODE_NORMAL = 1;
    public static final int MODE_GUI = 2;
    public static final int MODE_NOACT = 3;
    public boolean cancelableWaitEvents;
    private long prevInputEventNanoSec;
    private int prevWindowAttrib = 1;
    private long prevMovingEventMilliSec;
    private double prevX;
    private double prevY;
    private double prevZ;
    private float prevRotationYaw;
    private float prevRotationPitch;
    private class_9927 curInactivityFpsLimit = null;
    private int tpsCounter = 0;
    private long prevUpdateTime;
    private int curTps;
    private String prevReason = "";

    public WakeupEventHandler() {
        class_315 cfr_ignored_0 = class_310.method_1551().field_1690;
        this.maxFPS = 260;
        Logger.debug("MaxFramerate=", this.maxFPS);
        this.fpsMode = 1;
        InputEventHandler.INSTANCE.addCallbacks();
    }

    public void onMouseClicked() {
        this.makeWindowStatusActive();
        this.prevInputEventNanoSec = InputEventHandler.INSTANCE.getLastEventNanoSec();
        this.resetWaitingTimer();
        this.recoverFPS("mouse clicked");
    }

    public void onMouseScroll() {
        if (GlfwUtils.isWindowFocused() || !Config.CURRENT.reducingInBackground) {
            this.makeWindowStatusActive();
            this.prevInputEventNanoSec = InputEventHandler.INSTANCE.getLastEventNanoSec();
            this.resetWaitingTimer();
            this.recoverFPS("mouse wheel");
        }
    }

    public void onKeyboardKeyPressed() {
        this.makeWindowStatusActive();
        this.prevInputEventNanoSec = InputEventHandler.INSTANCE.getLastEventNanoSec();
        this.resetWaitingTimer();
        this.recoverFPS("key pressed event");
    }

    private void makeWindowStatusActive() {
        if (this.prevWindowAttrib == 0) {
            Logger.debug("Window has been active. (onInputEvent)");
        }
        this.prevWindowAttrib = 1;
        this.recoverSound();
    }

    public void onClientTick() {
        this.checkWakeupEvent();
        this.calcTps();
    }

    private void calcTps() {
        ++this.tpsCounter;
        long curTime = System.currentTimeMillis();
        long elapsedTime = curTime - this.prevUpdateTime;
        if (elapsedTime >= 1000L) {
            this.curTps = Math.round((float)this.tpsCounter * (1000.0f / (float)elapsedTime));
            this.tpsCounter = 0;
            this.prevUpdateTime = curTime;
        }
    }

    public int getTps() {
        return this.curTps;
    }

    private void checkWakeupEvent() {
        block21: {
            if (this.fpsMode != 0) {
                this.cancelableWaitEvents = false;
            }
            if (!Config.CURRENT.enableFpsReducer) {
                this.resetWaitingTimer();
                this.recoverNormalFPS("FPS Reducer disabled");
                return;
            }
            if (Config.CURRENT.profile == 5 && this.curInactivityFpsLimit != this.mc.field_1690.method_61970().method_41753()) {
                Config.CURRENT.setProfile(5);
                this.curInactivityFpsLimit = (class_9927)this.mc.field_1690.method_61970().method_41753();
            }
            if (Config.CURRENT.reducingInBackground || Config.CURRENT.suppressSound) {
                int curWindowAttrib = GLFW.glfwGetWindowAttrib((long)this.windowHandle, (int)131073);
                if (curWindowAttrib == 0) {
                    if (curWindowAttrib != this.prevWindowAttrib) {
                        Logger.debug("Window has been inactive. (onClientTick)");
                        this.prevWindowAttrib = curWindowAttrib;
                        if (Config.CURRENT.suppressSound) {
                            this.stopSound();
                        }
                    }
                    if (Config.CURRENT.reducingInBackground) {
                        this.reduceFPS(0, "Window has been inactive.");
                        return;
                    }
                } else if (curWindowAttrib != this.prevWindowAttrib) {
                    Logger.debug("Window has been active. (onClientTick)");
                    this.prevInputEventNanoSec = InputEventHandler.INSTANCE.getLastEventNanoSec();
                    this.prevWindowAttrib = curWindowAttrib;
                    this.recoverSound();
                }
            }
            if (this.mc.field_1687 == null) {
                this.resetWaitingTimer();
                this.recoverFPS("world is null");
                return;
            }
            long currentInputEventNanoSec = InputEventHandler.INSTANCE.getLastEventNanoSec();
            if (currentInputEventNanoSec > this.prevInputEventNanoSec) {
                this.prevInputEventNanoSec = currentInputEventNanoSec;
                this.resetWaitingTimer();
                this.recoverFPS("GLFW input event");
                return;
            }
            try {
                if (this.mc.field_1724.field_3913.field_54155.comp_3159() || this.mc.field_1724.field_3913.field_54155.comp_3160() || this.mc.field_1724.field_3913.field_54155.comp_3161() || this.mc.field_1724.field_3913.field_54155.comp_3162() || this.mc.field_1724.field_3913.field_54155.comp_3163() || this.mc.field_1724.field_3913.field_54155.comp_3164()) {
                    this.resetWaitingTimer();
                    this.recoverFPS("movement input");
                    return;
                }
            }
            catch (NullPointerException e) {
                if (!Config.CURRENT.debugLog) break block21;
                e.printStackTrace();
            }
        }
        if (!Config.CURRENT.ignoreHoldButton) {
            for (int btn = 0; btn <= 7; ++btn) {
                int state = GLFW.glfwGetMouseButton((long)this.windowHandle, (int)btn);
                if (state != 1) continue;
                this.resetWaitingTimer();
                this.recoverFPS("keep mouse button pressed");
                break;
            }
        }
        switch (Config.CURRENT.detectMoving) {
            case 1: {
                if (this.mc.field_1724 == null || this.mc.field_1724.method_24828() || !this.checkMovingSimply() && !this.checkRotation()) break;
                this.resetWaitingTimer();
                this.recoverFPS("detected movement riding/flying");
                return;
            }
            case 2: {
                if (!this.checkMovingSimply() && !this.checkRotation()) break;
                this.resetWaitingTimer();
                this.recoverFPS("detected movement");
                return;
            }
        }
        this.checkWaitingTimer();
    }

    public static void checkWakeup() {
        INSTANCE.checkWakeupEvent();
    }

    private boolean checkMoving() {
        int interval = 1000;
        long curMovingEventMilliSec = System.currentTimeMillis();
        if (curMovingEventMilliSec - this.prevMovingEventMilliSec >= 1000L & this.mc.field_1724 != null) {
            double posX = this.mc.field_1724.method_23317();
            double posY = this.mc.field_1724.method_23318();
            double posZ = this.mc.field_1724.method_23321();
            double mx = posX - this.prevX;
            double my = posY - this.prevY;
            double mz = posZ - this.prevZ;
            double movement = mx * mx + my * my + mz * mz;
            Logger.debug("movement:" + Math.sqrt(movement));
            this.prevX = posX;
            this.prevY = posY;
            this.prevZ = posZ;
            this.prevMovingEventMilliSec = curMovingEventMilliSec;
            double threshold = 0.9;
            return movement >= threshold * threshold;
        }
        return false;
    }

    private boolean checkMovingSimply() {
        if (this.mc.field_1724 != null) {
            double posX = this.mc.field_1724.method_23317();
            double posY = this.mc.field_1724.method_23318();
            double posZ = this.mc.field_1724.method_23321();
            if (this.prevX != posX || this.prevY != posY || this.prevZ != posZ) {
                this.prevX = posX;
                this.prevY = posY;
                this.prevZ = posZ;
                return true;
            }
        }
        return false;
    }

    private boolean checkRotation() {
        if (this.mc.field_1724 != null && (this.prevRotationYaw != this.mc.field_1724.method_36454() || this.prevRotationPitch != this.mc.field_1724.method_36455())) {
            this.prevRotationYaw = this.mc.field_1724.method_36454();
            this.prevRotationPitch = this.mc.field_1724.method_36455();
            return true;
        }
        return false;
    }

    private void resetWaitingTimer() {
        this.idleStartTime = System.currentTimeMillis();
    }

    private void checkWaitingTimer() {
        int waitingMs = Config.CURRENT.waitingTime * 1000;
        long idleTime = System.currentTimeMillis() - this.idleStartTime;
        if (Config.CURRENT.reducingInGameMenu && GuiOpenEventHandler.guiGameMenuOpened) {
            waitingMs = 200;
        }
        if (this.fpsMode != 0) {
            if (waitingMs != 0 && idleTime > (long)waitingMs) {
                this.reduceFPS(0, "Waiting time has been expired.");
            } else if (this.fpsMode != 3 & Config.CURRENT.noActFps > 0 & idleTime > (long)Config.CURRENT.noActTime) {
                this.reduceFPS(3, "No action was detected within " + Config.CURRENT.noActTime + "ms.");
            }
        }
    }

    private void reduceFPS(int mode, String reason) {
        switch (mode) {
            case 0: 
            case 2: {
                if (this.fpsMode == 0) break;
                if (GuiOpenEventHandler.guiOpened && Config.CURRENT.guiScreenFps != 0 && Config.CURRENT.guiScreenFps <= Config.CURRENT.idleFps) {
                    this.setFramerateLimit(Config.CURRENT.guiScreenFps, 2);
                } else {
                    this.setFramerateLimit(Config.CURRENT.idleFps, 0);
                    this.setCancelableWaitEvents();
                    InputEventHandler.INSTANCE.clearInputEventInIdle();
                }
                this.loggingReduceFps(reason);
                break;
            }
            case 3: {
                if (Config.CURRENT.noActFps <= 0 || this.fpsMode != 1 && (this.fpsMode != 2 || Config.CURRENT.noActFps >= Config.CURRENT.guiScreenFps)) break;
                this.setFramerateLimit(Config.CURRENT.noActFps, 3);
                this.loggingReduceFps(reason);
                break;
            }
        }
    }

    private void recoverFPS(String reason) {
        if (this.fpsMode != 1) {
            if (GuiOpenEventHandler.guiOpened && Config.CURRENT.guiScreenFps != 0) {
                this.setFramerateLimit(Config.CURRENT.guiScreenFps, 2);
            } else {
                this.setFramerateLimit((Integer)this.mc.field_1690.method_42524().method_41753(), 1);
            }
            this.loggingRecoverFps(reason);
        }
    }

    private void recoverNormalFPS(String reason) {
        if (this.fpsMode != 1) {
            this.setFramerateLimit((Integer)this.mc.field_1690.method_42524().method_41753(), 1);
            this.loggingRecoverFps(reason);
        }
    }

    private void loggingReduceFps(String reason) {
        if (Config.CURRENT.debugLog && !this.prevReason.equals(reason)) {
            this.prevReason = reason;
            Logger.debug("Reducing max FPS: ", this.getFramerateLimit(), " (reason: ", reason, ")");
        }
    }

    private void loggingRecoverFps(String reason) {
        if (Config.CURRENT.debugLog && !this.prevReason.equals(reason)) {
            this.prevReason = reason;
            int framerateLimit = this.getFramerateLimit();
            if (framerateLimit == this.maxFPS) {
                Logger.debug("Recovering max FPS: Unlimited (reason: ", reason, ")");
            } else {
                Logger.debug("Recovering max FPS: ", framerateLimit, " (reason: ", reason, ")");
            }
        }
    }

    public void forceReduceFPS(int mode, String reason) {
        this.reduceFPS(mode, "[force reduce] " + reason);
    }

    public void forceRecoverFPS(String reason) {
        this.fpsMode = 2;
        this.resetWaitingTimer();
        this.recoverFPS("[force recover] " + reason);
    }

    private void stopSound() {
        if (!this.stopSound) {
            this.currentGameSettingVolume = this.mc.field_1690.method_1630(class_3419.field_15250);
            float ratio = Config.CURRENT.suppressedVolume;
            ratio = ratio <= 0.0f ? 0.001f : ratio;
            float newVolume = this.currentGameSettingVolume * ratio / 100.0f;
            this.mc.method_1483().method_4865(class_3419.field_15250, newVolume);
            this.stopSound = true;
            Logger.debug("Suppressing master volume: ", (int)(newVolume * 100.0f));
        }
    }

    private void recoverSound() {
        if (this.stopSound) {
            this.mc.method_1483().method_4865(class_3419.field_15250, this.currentGameSettingVolume);
            this.stopSound = false;
            Logger.debug("Recovering master volume: ", (int)(this.currentGameSettingVolume * 100.0f));
        }
    }

    private int getWaitingTimeSecond() {
        return (int)(System.currentTimeMillis() - this.idleStartTime) / 1000;
    }

    private void setCancelableWaitEvents() {
        if (Config.CURRENT.noWaitRecovery) {
            this.cancelableWaitEvents = true;
        }
    }

    private void setFramerateLimit(int framerateLimit, int mode) {
        this.fpsMode = mode;
        class_9919 framerateLimitTracker = this.mc.method_61964();
        if (framerateLimitTracker == null) {
            Logger.debug("FramerateLimitTracker is null. FPS is not changed.");
            return;
        }
        framerateLimitTracker.method_61938(framerateLimit);
    }

    private int getFramerateLimit() {
        class_9919 framerateLimitTracker = this.mc.method_61964();
        if (framerateLimitTracker == null) {
            if (this.mc.field_1690 == null) {
                Logger.debug("FramerateLimitTracker and mc.options are null. Assume that the FPS is 60.");
                return 60;
            }
            Logger.debug("FramerateLimitTracker is null. Get from option.");
            return (Integer)this.mc.field_1690.method_42524().method_41753();
        }
        return this.mc.method_61964().method_61937();
    }
}

