/*
 * Decompiled with CFR 0.152.
 */
package bre2el.fpsreducer.config;

import bre2el.fpsreducer.config.ConfigManager;
import bre2el.fpsreducer.config.Profile;
import bre2el.fpsreducer.gui.HudPos;
import bre2el.fpsreducer.util.Logger;
import net.minecraft.class_9848;

public class Config
extends Profile {
    public static Config CURRENT = new Config();
    public boolean enableFpsReducer;
    private int hudReferencePos;
    public HudPos[] hudPos = new HudPos[9];
    public double hudScale;
    public int hudBehindChatBox;
    public static final int HUD_BEFIND_CHATBOX_KEEP = 0;
    public static final int HUD_BEHIND_CHATBOX_OFF = 1;
    public static final int HUD_BEHIND_CHATBOX_DODGE = 2;
    public int hudInfo;
    public static final int HUD_INFO_DISABLED = 0;
    public static final int HUD_INFO_FPS_CPU_LONG = 1;
    public static final int HUD_INFO_FPS_CPU_SHORT = 2;
    public static final int HUD_INFO_FPS_CPU_2LINES = 3;
    public static final int HUD_INFO_FPS_ONLY = 4;
    public static final int HUD_INFO_CPU_ONLY = 5;
    public static final int HUD_INFO_SIMPLE = 6;
    protected transient HudPos[] hudPosDefault = new HudPos[9];
    public transient HudPos curHudPos;
    public String hudColor;
    public String hudPreText = "FPS: ";
    public String hudReductionColor;
    public String hudReductionPreText = "ECO: ";
    public String hudGuiModeColor;
    public String hudGuiModePreText = "FPS: ";
    public String hudNoActModeColor;
    private final transient String COLOR_IDLE = "00f000";
    private final transient String COLOR_NORMAL = "f0f0f0";
    private final transient String COLOR_GUI = "b6ecff";
    private final transient String COLOR_NOACT = "ceffd4";
    public int cpuUsageType;
    public static final int CPU_USAGE_TYPE_ONE_CPU_BASIS = 0;
    public static final int CPU_USAGE_TYPE_ALL_CPU_BASIS = 1;
    public int cpuUsageThread;
    public static final int CPU_USAGE_THREAD_CLIENT_ONLY = 0;
    public static final int CPU_USAGE_THREAD_ALL = 1;
    public boolean allowOneFps;
    public transient boolean noWaitRecovery = true;
    public boolean debugLog;
    public transient int hudColorDec;
    public transient int hudReductionColorDec;
    public transient int hudGuiModeColorDec;
    public transient int hudNoActModeColorDec;

    public Config() {
        int i;
        for (i = 0; i < 9; ++i) {
            this.hudPos[i] = new HudPos(i);
            this.hudPosDefault[i] = new HudPos(i);
        }
        this.initHudPosDefaultValues();
        this.enableFpsReducer = true;
        this.hudReferencePos = 3;
        this.hudScale = 1.0;
        this.hudBehindChatBox = 2;
        this.hudInfo = 4;
        for (i = 0; i < 8; ++i) {
            this.hudPos[i + 1] = this.hudPosDefault[i + 1].copy();
        }
        this.hudColor = "f0f0f0";
        this.hudReductionColor = "00f000";
        this.hudGuiModeColor = "b6ecff";
        this.cpuUsageType = 0;
        this.cpuUsageThread = 0;
        this.allowOneFps = false;
        this.debugLog = false;
        this.hudColor = "f0f0f0";
        this.hudReductionColor = "00f000";
        this.hudGuiModeColor = "b6ecff";
        this.hudNoActModeColor = "ceffd4";
        this.update();
    }

    public void update() {
        this.setHudReferencePos(this.hudReferencePos);
        this.hudColorDec = class_9848.method_61334((int)Config.hexToDec(this.hudColor, Config.hexToDec("f0f0f0")));
        this.hudReductionColorDec = class_9848.method_61334((int)Config.hexToDec(this.hudReductionColor, Config.hexToDec("00f000")));
        this.hudGuiModeColorDec = class_9848.method_61334((int)Config.hexToDec(this.hudGuiModeColor, Config.hexToDec("b6ecff")));
        this.hudNoActModeColorDec = class_9848.method_61334((int)Config.hexToDec(this.hudNoActModeColor, Config.hexToDec("ceffd4")));
    }

    public void prepareSave() {
        this.hudColor = Config.decToHex(class_9848.method_61335((int)this.hudColorDec));
        this.hudReductionColor = Config.decToHex(class_9848.method_61335((int)this.hudReductionColorDec));
        this.hudGuiModeColor = Config.decToHex(class_9848.method_61335((int)this.hudGuiModeColorDec));
        this.hudNoActModeColor = Config.decToHex(class_9848.method_61335((int)this.hudNoActModeColorDec));
    }

    protected void initHudPosDefaultValues() {
        this.hudPosDefault[1].setOffset(2, 2);
        this.hudPosDefault[2].setOffset(0, 2);
        this.hudPosDefault[3].setOffset(-2, 2);
        this.hudPosDefault[4].setOffset(-2, 0);
        this.hudPosDefault[5].setOffset(-2, -2);
        this.hudPosDefault[6].setOffset(0, -2);
        this.hudPosDefault[7].setOffset(2, -2);
        this.hudPosDefault[8].setOffset(2, 0);
        this.hudPosDefault[1].alignment = 0;
        this.hudPosDefault[2].alignment = 2;
        this.hudPosDefault[3].alignment = 1;
        this.hudPosDefault[4].alignment = 1;
        this.hudPosDefault[5].alignment = 1;
        this.hudPosDefault[6].alignment = 2;
        this.hudPosDefault[7].alignment = 0;
        this.hudPosDefault[8].alignment = 0;
    }

    public static void setInstance(Config newConf) {
        CURRENT = newConf;
    }

    public void setHudReferencePos(int loc) {
        this.hudReferencePos = loc;
        this.curHudPos = this.hudPos[loc];
    }

    public int getHudReferencePos() {
        return this.hudReferencePos;
    }

    public void resetHudOffsetsAndAlignments() {
        for (int i = 0; i < 8; ++i) {
            this.hudPos[i + 1].setOffset(this.hudPosDefault[i + 1].offsetX, this.hudPosDefault[i + 1].offsetY);
            this.hudPos[i + 1].alignment = this.hudPosDefault[i + 1].alignment;
        }
        ConfigManager.save();
    }

    private static int hexToDec(String hexString) {
        return Config.hexToDec(hexString, 0);
    }

    private static int hexToDec(String hexString, int defaultVal) {
        int intValue;
        try {
            intValue = Integer.parseInt(hexString, 16);
        }
        catch (NumberFormatException ne) {
            Logger.error("Parsing configuration error: " + hexString);
            return defaultVal;
        }
        return intValue;
    }

    private static String decToHex(int intValue) {
        String hexString = String.format("%06x", intValue);
        return hexString;
    }
}

