/*
 * Decompiled with CFR 0.152.
 */
package se.icus.mag.modsettings;

import com.terraformersmc.modmenu.api.ConfigScreenFactory;
import com.terraformersmc.modmenu.api.ModMenuApi;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.fabricmc.loader.api.EntrypointException;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.entrypoint.EntrypointContainer;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.minecraft.class_437;
import org.apache.logging.log4j.Level;
import se.icus.mag.modsettings.Main;

public class ModRegistry {
    private static final ModRegistry INSTANCE = new ModRegistry();
    private final Map<String, String> modNames = new HashMap<String, String>();
    private final Map<String, ConfigScreenFactory<?>> configScreenFactories = new HashMap();
    private final Map<String, ConfigScreenFactory<?>> overridingConfigScreenFactories = new HashMap();

    private ModRegistry() {
    }

    public static ModRegistry getInstance() {
        return INSTANCE;
    }

    public void registerMods() {
        List modList = FabricLoader.getInstance().getEntrypointContainers("modmenu", Object.class);
        for (EntrypointContainer entryPoint : modList) {
            ModMetadata metadata = entryPoint.getProvider().getMetadata();
            String modId = metadata.getId();
            try {
                Object unknownApi = entryPoint.getEntrypoint();
                if (!(unknownApi instanceof ModMenuApi)) {
                    Main.LOGGER.warn("Unknown Mod Menu API version for mod " + modId + ", class: " + String.valueOf(unknownApi.getClass()));
                    continue;
                }
                ModMenuApi modernApi = (ModMenuApi)unknownApi;
                Main.LOGGER.log(Level.INFO, "Found configurable mod: " + modId + ", " + metadata.getName());
                ModMenuApi modApi = modernApi;
                this.configScreenFactories.put(modId, modApi.getModConfigScreenFactory());
                Map<String, ConfigScreenFactory<?>> overridingFactories = modApi.getProvidedConfigScreenFactories();
                this.overridingConfigScreenFactories.putAll(overridingFactories);
                this.modNames.put(modId, metadata.getName());
                for (String overriddenModId : overridingFactories.keySet()) {
                    Optional container = FabricLoader.getInstance().getModContainer(overriddenModId);
                    if (!container.isPresent()) continue;
                    String modName = ((ModContainer)container.get()).getMetadata().getName();
                    Main.LOGGER.log(Level.INFO, "Found overridden config for mod: " + overriddenModId + ", " + modName);
                    this.modNames.put(overriddenModId, modName);
                }
            }
            catch (EntrypointException e) {
                Main.LOGGER.warn("Mod Menu API problem with mod " + modId, (Throwable)e);
            }
        }
    }

    public List<String> getAllModIds() {
        Comparator<String> sorter = Comparator.comparing(modId -> modId.toLowerCase(Locale.ROOT));
        return this.modNames.keySet().stream().sorted(sorter).filter(modId -> !modId.equals("minecraft")).collect(Collectors.toList());
    }

    public String getModName(String modId) {
        return this.modNames.get(modId);
    }

    private class_437 getScreen(String modid, Map<String, ConfigScreenFactory<?>> map, class_437 parentScreen) {
        ConfigScreenFactory<?> factory = map.get(modid);
        return factory != null ? (class_437)factory.create(parentScreen) : null;
    }

    public class_437 getConfigScreen(String modid, class_437 parentScreen) {
        class_437 configScreen = this.getScreen(modid, this.configScreenFactories, parentScreen);
        if (configScreen == null) {
            configScreen = this.getScreen(modid, this.overridingConfigScreenFactories, parentScreen);
        }
        return configScreen;
    }
}

