/*
 * Decompiled with CFR 0.152.
 */
package dlovin.inventoryhud.config.gui;

import dlovin.inventoryhud.InventoryHUD;
import dlovin.inventoryhud.config.gui.PotionConfigScreen;
import dlovin.inventoryhud.config.gui.ScreenWithOptionList;
import dlovin.inventoryhud.config.widgets.ButtonWidget;
import dlovin.inventoryhud.config.widgets.CustomButton;
import dlovin.inventoryhud.config.widgets.CustomOptionList;
import dlovin.inventoryhud.config.widgets.IconWidget;
import dlovin.inventoryhud.config.widgets.TextField;
import dlovin.inventoryhud.references.Translation;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_437;
import org.jetbrains.annotations.NotNull;

public class EffectsBlacklistScreen
extends ScreenWithOptionList {
    private final boolean inGame;
    private CustomButton saveBtn;
    private final class_437 prevScreen;

    public EffectsBlacklistScreen(class_437 prevScreen, boolean inGame) {
        super(Translation.BLACKLIST_TITLE);
        this.inGame = inGame;
        this.prevScreen = prevScreen;
    }

    protected void method_25426() {
        this.optionList = new CustomOptionList(this.field_22787, this, 32);
        this.addControlLine();
        List<String> effectList = InventoryHUD.getConfig().getEffectsBlacklist();
        for (int i = 0; i < effectList.size(); ++i) {
            this.addLine(i, effectList.get(i));
        }
        this.method_37063((class_364)this.optionList);
    }

    private void addLine(int i, String effect) {
        IconWidget effectIcon = new IconWidget(this.field_22789 / 2 + 105, 0, 20, 20, effect);
        this.optionList.insertWidget(effectIcon, i);
        this.optionList.addWidget(new TextField(this.field_22793, this.field_22789 / 2 - 100, 0, 200, 20, effect, w -> {
            effectIcon.setEffectAtlasSprite(w.getText());
            this.saveBtn.setMessage(String.valueOf(class_124.field_1061) + Translation.SAVE.getString());
        }, "[a-z0-9._-]*[/:]?[a-z0-9._-]*"), i);
        int deleteBtnSize = this.field_22793.method_1727(Translation.DELETE.getString()) + 8;
        CustomButton deleteBtn = new CustomButton(this.field_22789 / 2 - deleteBtnSize - 105, 0, deleteBtnSize, 20, Translation.DELETE.getString(), null, false);
        this.optionList.addWidget(deleteBtn, i);
        deleteBtn.addListener(btn -> {
            this.optionList.removeRowWith(deleteBtn);
            this.saveBtn.setMessage(String.valueOf(class_124.field_1061) + Translation.SAVE.getString());
        });
    }

    private void addControlLine() {
        int saveBtnSize = this.field_22793.method_1727(Translation.SAVE.getString()) + 8;
        int addBtnSize = this.field_22793.method_1727(Translation.ADD.getString()) + 8;
        this.saveBtn = new CustomButton(this.field_22789 / 2 - saveBtnSize - 5, 0, saveBtnSize, 20, String.valueOf(class_124.field_1060) + Translation.SAVE.getString(), null, false);
        this.optionList.addWidget(this.saveBtn, 0);
        this.saveBtn.addListener(this::saveEffects);
        CustomButton nextButton = new CustomButton(this.field_22789 / 2 + 5, 0, addBtnSize, 20, Translation.ADD.getString(), null, false);
        this.optionList.addWidget(nextButton, 0);
        nextButton.addListener(this::addEffect);
    }

    private void saveEffects(ButtonWidget btn) {
        List<String> effects = this.optionList.getWidgets().stream().filter(w -> w instanceof TextField).map(w -> ((TextField)w).getText()).toList();
        InventoryHUD.getConfig().setEffectsBlacklist(effects);
        InventoryHUD.getInstance().getInvhudGUI().resetBlackList();
        this.saveBtn.setMessage(String.valueOf(class_124.field_1060) + Translation.SAVE.getString());
    }

    private void addEffect(ButtonWidget btn) {
        this.addLine(this.optionList.rowsCount() - 1, "");
        this.saveBtn.setMessage(String.valueOf(class_124.field_1061) + Translation.SAVE.getString());
    }

    public void method_25394(@NotNull class_332 context, int mouseX, int mouseY, float partialTick) {
        context.method_25296(0, 0, context.method_51421(), 32, -587202560, -2013265920);
        this.optionList.method_25394(context, mouseX, mouseY, partialTick);
        this.renderTitle(context);
        this.optionList.renderTooltips(context, mouseX, mouseY);
    }

    public void renderTitle(@NotNull class_332 context) {
        context.method_51448().pushMatrix();
        context.method_51448().translate((float)(this.field_22789 / 2), 10.0f);
        context.method_51448().pushMatrix();
        context.method_51448().scale(2.0f, 2.0f);
        context.method_35719(this.field_22793, this.field_22785.method_30937(), 0, 0, -1);
        context.method_51448().popMatrix();
        context.method_51448().popMatrix();
    }

    public void method_25419() {
        this.field_22787.method_1507((class_437)new PotionConfigScreen(this.prevScreen, this.inGame));
    }
}

