/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_texture_features.features.property_reading.properties.optifine_properties;

import it.unimi.dsi.fastutil.Function;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import net.minecraft.class_2483;
import net.minecraft.class_2487;
import net.minecraft.class_2514;
import net.minecraft.class_2520;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import traben.entity_texture_features.features.property_reading.properties.RandomProperty;
import traben.entity_texture_features.features.property_reading.properties.generic_properties.SimpleIntegerArrayProperty;
import traben.entity_texture_features.features.property_reading.properties.generic_properties.StringArrayOrRegexProperty;
import traben.entity_texture_features.features.state.ETFEntityRenderState;
import traben.entity_texture_features.utils.ETFUtils2;

public class NBTProperty
extends RandomProperty {
    private final Map<String, NBTTester> NBT_MAP;
    private boolean printAll = false;
    private final String prefix;
    protected static final class_2487 INTENTIONAL_FAILURE = new class_2487();
    private static Set<String> crashMessages = new HashSet<String>();
    private boolean nullMessage = true;

    protected NBTProperty(Properties properties, int propertyNum, String nbtPrefix) throws RandomProperty.RandomPropertyException {
        this.prefix = nbtPrefix;
        String keyPrefix = this.prefix + "." + propertyNum + ".";
        this.NBT_MAP = new Object2ObjectLinkedOpenHashMap();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String key = entry.getKey().toString();
            if (key == null || !key.startsWith(keyPrefix)) continue;
            String nbtName = key.replaceFirst(keyPrefix, "");
            String instruction = entry.getValue().toString().trim().replace("print_raw:", "print:raw:");
            if (!nbtName.isBlank() && !instruction.isBlank()) {
                this.printAll = this.printAll || instruction.startsWith("print_all:");
                this.NBT_MAP.put(nbtName, NBTTester.of(nbtName, instruction));
                continue;
            }
            throw new RandomProperty.RandomPropertyException("NBT failed, as instruction or nbt name was blank: " + keyPrefix + nbtName + "=" + instruction);
        }
        if (this.NBT_MAP.isEmpty()) {
            throw new RandomProperty.RandomPropertyException("NBT failed as the final testing map was empty");
        }
    }

    public static NBTProperty getPropertyOrNull(Properties properties, int propertyNum) {
        try {
            return new NBTProperty(properties, propertyNum, "nbt");
        }
        catch (RandomProperty.RandomPropertyException e) {
            return null;
        }
    }

    private static boolean isStringValidInt(String string) {
        try {
            Integer.parseInt(string);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    @Nullable
    protected class_2487 getEntityNBT(ETFEntityRenderState entity) {
        return entity.nbt();
    }

    @Override
    protected boolean testEntityInternal(ETFEntityRenderState entity) {
        class_2487 entityNBT;
        if (entity == null) {
            if (this.printAll || this.nullMessage) {
                this.nullMessage = false;
                ETFUtils2.logError(this.prefix + " test failed reading null entity NBT: ");
            }
            return false;
        }
        try {
            entityNBT = this.getEntityNBT(entity);
        }
        catch (Exception e) {
            String crashMessage = e.getMessage();
            if (this.printAll || !crashMessages.contains(crashMessage)) {
                if (!this.printAll) {
                    crashMessages.add(crashMessage);
                }
                ETFUtils2.logError(this.prefix + " test crashed reading entity NBT: " + crashMessage);
                e.printStackTrace();
            }
            throw e;
        }
        if (entityNBT == INTENTIONAL_FAILURE) {
            if (this.printAll) {
                ETFUtils2.logMessage(this.prefix + " property [full] print:\n<NBT is missing>");
            }
            return false;
        }
        if (entityNBT == null || entityNBT.method_33133()) {
            if (this.printAll) {
                ETFUtils2.logMessage(this.prefix + " property [full] print:\n<NBT is empty or missing>");
            }
            ETFUtils2.logError(this.prefix + " test failed, as could not read entity NBT");
            return false;
        }
        if (this.printAll) {
            ETFUtils2.logMessage(this.prefix + " property [full] print:\n" + this.formatNbtPretty(entityNBT));
        }
        return this.testAllNBTCases(entityNBT);
    }

    protected boolean testAllNBTCases(class_2487 entityNBT) {
        for (Map.Entry<String, NBTTester> nbtPropertyEntry : this.NBT_MAP.entrySet()) {
            boolean doesTestPass;
            NBTTester data = nbtPropertyEntry.getValue();
            List<class_2520> finalNBTElement = this.findNBTElements(entityNBT, nbtPropertyEntry.getKey());
            if (finalNBTElement == null) {
                doesTestPass = data.wantsBlank;
            } else {
                boolean found = false;
                for (class_2520 nbt : finalNBTElement) {
                    if (nbt != null && (found = ((Boolean)data.tester.apply((Object)nbt)).booleanValue())) break;
                }
                doesTestPass = found;
            }
            if (data.print) {
                String printString = finalNBTElement == null ? "<NBT component not found>" : finalNBTElement.stream().map(NBTProperty::getAsString).reduce("", (a, b) -> a + "\n" + b);
                ETFUtils2.logMessage(this.prefix + " NBT property [single] print data: " + nbtPropertyEntry.getKey() + "=" + printString);
                ETFUtils2.logMessage(this.prefix + " NBT property [single] print result: " + (data.inverts != doesTestPass));
            }
            if (data.inverts != doesTestPass) continue;
            return false;
        }
        return true;
    }

    private static String getAsString(class_2520 nbt) {
        return nbt.method_68658().orElseGet(() -> ((class_2520)nbt).toString());
    }

    private static Number getAsNumber(class_2514 nbt) {
        return nbt.method_68599().orElse(0);
    }

    public String formatNbtPretty(class_2487 nbt) {
        String input = NBTProperty.getAsString((class_2520)nbt);
        StringBuilder output = new StringBuilder();
        int indent = 1;
        boolean inString = false;
        block7: for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (inString && c != '\"') {
                output.append(c);
                continue;
            }
            switch (c) {
                case '[': 
                case '{': {
                    output.append(c).append('\n');
                    output.append(" ".repeat(indent += 4));
                    continue block7;
                }
                case ']': 
                case '}': {
                    output.append('\n').append(" ".repeat(indent -= 4)).append(c);
                    continue block7;
                }
                case ',': {
                    output.append(c).append('\n').append(" ".repeat(indent));
                    continue block7;
                }
                case '\"': {
                    inString = !inString;
                    output.append(c);
                    continue block7;
                }
                case ':': {
                    output.append(c).append(" ");
                    continue block7;
                }
                default: {
                    output.append(c);
                }
            }
        }
        return output.toString().replaceAll("\\{\\s+}", "{}").replaceAll("\\[\\s+]", "[]");
    }

    @Nullable
    private List<class_2520> findNBTElements(class_2487 entityNBT, String nbtIdentifier) {
        String[] instructions = nbtIdentifier.split("\\.");
        int index = 0;
        return this.findByIteration((class_2520)entityNBT, instructions, index);
    }

    @Nullable
    private List<class_2520> findByIteration(class_2520 element, String[] instructions, int index) {
        if (index >= instructions.length || element == null) {
            return null;
        }
        String instruction = instructions[index];
        List<class_2520> nextElements = null;
        if (element instanceof class_2487) {
            class_2487 nbtCompound = (class_2487)element;
            class_2520 single = nbtCompound.method_10580(instruction);
            if (single != null) {
                boolean notFinalInstruction = index < instructions.length - 1;
                nextElements = notFinalInstruction ? this.findByIteration(single, instructions, index + 1) : Collections.singletonList(single);
            }
        } else if (element instanceof class_2483) {
            class_2483 nbtList = (class_2483)element;
            nextElements = this.handleListInstruction(nbtList, instructions, index);
        }
        if (nextElements == null || nextElements.isEmpty()) {
            return null;
        }
        return nextElements;
    }

    @Nullable
    private List<class_2520> handleListInstruction(class_2483 nbtList, String[] instructions, int index) {
        boolean notFinalInstruction;
        if (index >= instructions.length || nbtList == null) {
            return null;
        }
        String instruction = instructions[index];
        boolean bl = notFinalInstruction = index < instructions.length - 1;
        if ("*".equals(instruction)) {
            if (notFinalInstruction) {
                ArrayList<class_2520> result = new ArrayList<class_2520>();
                for (class_2520 tag : nbtList) {
                    List<class_2520> find = this.findByIteration(tag, instructions, index + 1);
                    if (find == null) continue;
                    result.addAll(find);
                }
                return result.isEmpty() ? null : result;
            }
            return nbtList.stream().toList();
        }
        if (notFinalInstruction && NBTProperty.isStringValidInt(instruction)) {
            try {
                return Collections.singletonList(nbtList.method_10534(Integer.parseInt(instruction)));
            }
            catch (IndexOutOfBoundsException e) {
                return null;
            }
        }
        return null;
    }

    @Override
    @NotNull
    public String[] getPropertyIds() {
        return new String[]{"nbt"};
    }

    @Override
    protected String getPrintableRuleInfo() {
        return null;
    }

    public record NBTTester(boolean inverts, Function<class_2520, Boolean> tester, boolean wantsBlank, boolean print) {
        public static NBTTester of(String nbtId, String instructionMaybePrint) throws RandomProperty.RandomPropertyException {
            try {
                String instruction;
                String step1 = instructionMaybePrint.replaceFirst("^print_all:", "");
                boolean printSingle = step1.startsWith("print:");
                String step2 = printSingle ? step1.substring(6) : step1;
                boolean invert = step2.startsWith("!");
                String string = instruction = invert ? step2.substring(1) : step2;
                if (instruction.startsWith("raw:")) {
                    StringArrayOrRegexProperty.RegexAndPatternPropertyMatcher matcher;
                    String raw = instruction.replaceFirst("raw:", "");
                    boolean blank = raw.isBlank();
                    StringArrayOrRegexProperty.RegexAndPatternPropertyMatcher regexAndPatternPropertyMatcher = matcher = blank ? String::isBlank : StringArrayOrRegexProperty.getStringMatcher_Regex_Pattern_List_Single(raw);
                    if (matcher == null) {
                        throw new RandomProperty.RandomPropertyException("NBT failed, as raw: instruction was invalid: " + instruction);
                    }
                    return new NBTTester(invert, (Function<class_2520, Boolean>)((Function)s -> matcher.testString(NBTProperty.getAsString((class_2520)s))), blank, printSingle);
                }
                if (instruction.startsWith("exists:")) {
                    boolean exists = instruction.contains("exists:true");
                    boolean notExists = instruction.contains("exists:false");
                    return new NBTTester(invert, (Function<class_2520, Boolean>)((Function)s -> exists), notExists, printSingle);
                }
                if (instruction.startsWith("range:")) {
                    SimpleIntegerArrayProperty.IntRange range = SimpleIntegerArrayProperty.getIntRange(instruction.replaceFirst("range:", ""));
                    return new NBTTester(invert, (Function<class_2520, Boolean>)((Function)s -> {
                        if (s instanceof class_2514) {
                            class_2514 nbtNumber = (class_2514)s;
                            return range.isWithinRange(NBTProperty.getAsNumber(nbtNumber).intValue());
                        }
                        ETFUtils2.logWarn("Invalid range for non-number NBT: " + nbtId + "=" + instruction);
                        return false;
                    }), false, printSingle);
                }
                StringArrayOrRegexProperty.RegexAndPatternPropertyMatcher matcher = StringArrayOrRegexProperty.getStringMatcher_Regex_Pattern_List_Single(instruction);
                if (matcher == null) {
                    throw new RandomProperty.RandomPropertyException("NBT failed, as instruction was invalid: " + instruction);
                }
                return new NBTTester(invert, (Function<class_2520, Boolean>)((Function)s -> {
                    String test = s instanceof class_2514 ? NBTProperty.getAsString((class_2520)s).replaceAll("[^\\d.]", "") : NBTProperty.getAsString((class_2520)s);
                    return matcher.testString(test);
                }), false, printSingle);
            }
            catch (RandomProperty.RandomPropertyException e) {
                throw e;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RandomProperty.RandomPropertyException("NBT failed, unexpected exception: " + e.getMessage());
            }
        }
    }
}

