/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.ui.core;

import com.google.common.base.Preconditions;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import io.wispforest.owo.mixin.ui.access.DrawContextAccessor;
import io.wispforest.owo.ui.core.Color;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.OwoUIPipelines;
import io.wispforest.owo.ui.core.ParentComponent;
import io.wispforest.owo.ui.core.PositionedRectangle;
import io.wispforest.owo.ui.event.WindowResizeCallback;
import io.wispforest.owo.ui.renderstate.CircleElementRenderState;
import io.wispforest.owo.ui.renderstate.GradientQuadElementRenderState;
import io.wispforest.owo.ui.renderstate.LineElementRenderState;
import io.wispforest.owo.ui.renderstate.RingElementRenderState;
import io.wispforest.owo.ui.util.NinePatchTexture;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.class_10799;
import net.minecraft.class_11244;
import net.minecraft.class_11246;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5684;
import net.minecraft.class_8000;
import net.minecraft.class_8001;
import net.minecraft.class_8029;
import net.minecraft.class_8030;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3x2f;
import org.joml.Matrix3x2fc;

public class OwoUIDrawContext
extends class_332 {
    public static final class_2960 PANEL_NINE_PATCH_TEXTURE = class_2960.method_60655((String)"owo", (String)"panel/default");
    public static final class_2960 DARK_PANEL_NINE_PATCH_TEXTURE = class_2960.method_60655((String)"owo", (String)"panel/dark");
    public static final class_2960 PANEL_INSET_NINE_PATCH_TEXTURE = class_2960.method_60655((String)"owo", (String)"panel/inset");
    private final Consumer<Runnable> setTooltipDrawer;

    private OwoUIDrawContext(class_310 client, class_11246 renderState, Consumer<Runnable> setTooltipDrawer) {
        super(client, renderState);
        this.setTooltipDrawer = setTooltipDrawer;
    }

    public static OwoUIDrawContext of(class_332 context) {
        OwoUIDrawContext owoContext = new OwoUIDrawContext(class_310.method_1551(), context.field_59826, ((DrawContextAccessor)context)::owo$setTooltipDrawer);
        ((DrawContextAccessor)((Object)owoContext)).owo$setScissorStack(((DrawContextAccessor)context).owo$getScissorStack());
        ((DrawContextAccessor)((Object)owoContext)).owo$setMatrices(((DrawContextAccessor)context).owo$getMatrices());
        return owoContext;
    }

    public static UtilityScreen utilityScreen() {
        return UtilityScreen.get();
    }

    public boolean intersectsScissor(PositionedRectangle other) {
        class_8030 rect = this.field_44659.method_70863();
        if (rect == null) {
            return true;
        }
        class_8029 pos = rect.comp_1195();
        return other.x() < pos.comp_1193() + rect.comp_1196() && other.x() + other.width() >= pos.comp_1193() && other.y() < pos.comp_1194() + rect.comp_1197() && other.y() + other.height() >= pos.comp_1194();
    }

    public void drawRectOutline(int x, int y, int width, int height, int color) {
        this.drawRectOutline(class_10799.field_56879, x, y, width, height, color);
    }

    public void drawRectOutline(RenderPipeline pipeline, int x, int y, int width, int height, int color) {
        this.method_48196(pipeline, x, y, x + width, y + 1, color);
        this.method_48196(pipeline, x, y + height - 1, x + width, y + height, color);
        this.method_48196(pipeline, x, y + 1, x + 1, y + height - 1, color);
        this.method_48196(pipeline, x + width - 1, y + 1, x + width, y + height - 1, color);
    }

    public void drawGradientRect(int x, int y, int width, int height, int topLeftColor, int topRightColor, int bottomRightColor, int bottomLeftColor) {
        this.drawGradientRect(class_10799.field_56879, x, y, width, height, topLeftColor, topRightColor, bottomRightColor, bottomLeftColor);
    }

    public void drawGradientRect(RenderPipeline pipeline, int x, int y, int width, int height, int topLeftColor, int topRightColor, int bottomRightColor, int bottomLeftColor) {
        this.field_59826.method_70919((class_11244)new GradientQuadElementRenderState(pipeline, new Matrix3x2f((Matrix3x2fc)this.method_51448()), new class_8030(new class_8029(x, y), width, height), this.field_44659.method_70863(), Color.ofArgb(topLeftColor), Color.ofArgb(topRightColor), Color.ofArgb(bottomLeftColor), Color.ofArgb(bottomRightColor)));
    }

    public void drawPanel(int x, int y, int width, int height, boolean dark) {
        NinePatchTexture.draw(dark ? DARK_PANEL_NINE_PATCH_TEXTURE : PANEL_NINE_PATCH_TEXTURE, this, x, y, width, height);
    }

    public void drawSpectrum(int x, int y, int width, int height, boolean vertical) {
        this.field_59826.method_70919((class_11244)new GradientQuadElementRenderState(OwoUIPipelines.GUI_HSV, new Matrix3x2f((Matrix3x2fc)this.method_51448()), new class_8030(new class_8029(x, y), width, height), this.field_44659.method_70863(), Color.WHITE, new Color(vertical ? 1.0f : 0.0f, 1.0f, 1.0f), new Color(vertical ? 0.0f : 1.0f, 1.0f, 1.0f), new Color(0.0f, 1.0f, 1.0f)));
    }

    public void drawText(class_2561 text, float x, float y, float scale, int color) {
        this.drawText(text, x, y, scale, color, TextAnchor.TOP_LEFT);
    }

    public void drawText(class_2561 text, float x, float y, float scale, int color, TextAnchor anchorPoint) {
        class_327 textRenderer = class_310.method_1551().field_1772;
        this.method_51448().pushMatrix();
        this.method_51448().scale(scale, scale);
        switch (anchorPoint.ordinal()) {
            case 0: {
                x -= (float)textRenderer.method_27525((class_5348)text) * scale;
                break;
            }
            case 3: {
                Objects.requireNonNull(textRenderer);
                y -= 9.0f * scale;
                break;
            }
            case 1: {
                x -= (float)textRenderer.method_27525((class_5348)text) * scale;
                Objects.requireNonNull(textRenderer);
                y -= 9.0f * scale;
            }
        }
        this.method_51439(textRenderer, text, (int)(x * (1.0f / scale)), (int)(y * (1.0f / scale)), color, false);
        this.method_51448().popMatrix();
    }

    public void drawLine(int x1, int y1, int x2, int y2, double thiccness, Color color) {
        this.drawLine(class_10799.field_56879, x1, y1, x2, y2, thiccness, color);
    }

    public void drawLine(RenderPipeline pipeline, int x1, int y1, int x2, int y2, double thiccness, Color color) {
        this.field_59826.method_70919((class_11244)new LineElementRenderState(pipeline, new Matrix3x2f((Matrix3x2fc)this.method_51448()), this.field_44659.method_70863(), x1, y1, x2, y2, thiccness, color));
    }

    public void drawCircle(int centerX, int centerY, int segments, double radius, Color color) {
        this.drawCircle(OwoUIPipelines.GUI_TRIANGLE_FAN, centerX, centerY, segments, radius, color);
    }

    public void drawCircle(int centerX, int centerY, double angleFrom, double angleTo, int segments, double radius, Color color) {
        this.drawCircle(OwoUIPipelines.GUI_TRIANGLE_FAN, centerX, centerY, angleFrom, angleTo, segments, radius, color);
    }

    public void drawCircle(RenderPipeline pipeline, int centerX, int centerY, int segments, double radius, Color color) {
        this.drawCircle(pipeline, centerX, centerY, 0.0, 360.0, segments, radius, color);
    }

    public void drawCircle(RenderPipeline pipeline, int centerX, int centerY, double angleFrom, double angleTo, int segments, double radius, Color color) {
        Preconditions.checkArgument((angleFrom < angleTo ? 1 : 0) != 0, (Object)"angleFrom must be less than angleTo");
        this.field_59826.method_70919((class_11244)new CircleElementRenderState(pipeline, new Matrix3x2f((Matrix3x2fc)this.method_51448()), this.field_44659.method_70863(), centerX, centerY, angleFrom, angleTo, segments, radius, color));
    }

    public void drawRing(int centerX, int centerY, int segments, double innerRadius, double outerRadius, Color innerColor, Color outerColor) {
        this.drawRing(OwoUIPipelines.GUI_TRIANGLE_STRIP, centerX, centerY, segments, innerRadius, outerRadius, innerColor, outerColor);
    }

    public void drawRing(int centerX, int centerY, double angleFrom, double angleTo, int segments, double innerRadius, double outerRadius, Color innerColor, Color outerColor) {
        this.drawRing(OwoUIPipelines.GUI_TRIANGLE_STRIP, centerX, centerY, angleFrom, angleTo, segments, innerRadius, outerRadius, innerColor, outerColor);
    }

    public void drawRing(RenderPipeline pipeline, int centerX, int centerY, int segments, double innerRadius, double outerRadius, Color innerColor, Color outerColor) {
        this.drawRing(pipeline, centerX, centerY, 0.0, 360.0, segments, innerRadius, outerRadius, innerColor, outerColor);
    }

    public void drawRing(RenderPipeline pipeline, int centerX, int centerY, double angleFrom, double angleTo, int segments, double innerRadius, double outerRadius, Color innerColor, Color outerColor) {
        Preconditions.checkArgument((angleFrom < angleTo ? 1 : 0) != 0, (Object)"angleFrom must be less than angleTo");
        Preconditions.checkArgument((innerRadius < outerRadius ? 1 : 0) != 0, (Object)"innerRadius must be less than outerRadius");
        this.field_59826.method_70919((class_11244)new RingElementRenderState(pipeline, new Matrix3x2f((Matrix3x2fc)this.method_51448()), this.field_44659.method_70863(), centerX, centerY, angleFrom, angleTo, segments, innerRadius, outerRadius, innerColor, outerColor));
    }

    public void drawTooltip(class_327 textRenderer, int x, int y, List<class_5684> components) {
        this.drawTooltip(textRenderer, x, y, components, null);
    }

    public void drawTooltip(class_327 textRenderer, int x, int y, List<class_5684> components, @Nullable class_2960 texture) {
        ((DrawContextAccessor)((Object)this)).owo$drawTooltipImmediately(textRenderer, components, x, y, class_8001.field_41687, texture);
    }

    protected void method_71273(class_327 textRenderer, List<class_5684> components, int x, int y, class_8000 positioner, @Nullable class_2960 texture, boolean focused) {
        super.method_71273(textRenderer, components, x, y, positioner, texture, focused);
        this.setTooltipDrawer.accept(((DrawContextAccessor)((Object)this)).owo$getTooltipDrawer());
    }

    public void drawInsets(int x, int y, int width, int height, Insets insets, int color) {
        this.drawInsets(class_10799.field_56879, x, y, width, height, insets, color);
    }

    public void drawInsets(RenderPipeline pipeline, int x, int y, int width, int height, Insets insets, int color) {
        this.method_48196(pipeline, x - insets.left(), y - insets.top(), x + width + insets.right(), y, color);
        this.method_48196(pipeline, x - insets.left(), y + height, x + width + insets.right(), y + height + insets.bottom(), color);
        this.method_48196(pipeline, x - insets.left(), y, x, y + height, color);
        this.method_48196(pipeline, x + width, y, x + width + insets.right(), y + height, color);
    }

    public void drawInspector(ParentComponent root, double mouseX, double mouseY, boolean onlyHovered) {
        class_310 client = class_310.method_1551();
        class_327 textRenderer = client.field_1772;
        ArrayList<Component> children = new ArrayList<Component>();
        if (!onlyHovered) {
            root.collectDescendants(children);
        } else if (root.childAt((int)mouseX, (int)mouseY) != null) {
            children.add(root.childAt((int)mouseX, (int)mouseY));
        }
        RenderPipeline pipeline = class_10799.field_56879;
        for (Component child : children) {
            if (child instanceof ParentComponent) {
                ParentComponent parentComponent = (ParentComponent)child;
                this.drawInsets(pipeline, parentComponent.x(), parentComponent.y(), parentComponent.width(), parentComponent.height(), ((Insets)parentComponent.padding().get()).inverted(), -1492325155);
            }
            Insets margins = (Insets)child.margins().get();
            this.drawInsets(pipeline, child.x(), child.y(), child.width(), child.height(), margins, -1476398280);
            this.drawRectOutline(pipeline, child.x(), child.y(), child.width(), child.height(), -12930817);
            if (!onlyHovered) continue;
            int inspectorX = child.x() + 1;
            int inspectorY = child.y() + child.height() + ((Insets)child.margins().get()).bottom() + 1;
            Objects.requireNonNull(textRenderer);
            int inspectorHeight = 9 * 2 + 4;
            if (inspectorY > client.method_22683().method_4502() - inspectorHeight) {
                if ((inspectorY -= child.fullSize().height() + inspectorHeight + 1) < 0) {
                    inspectorY = 1;
                }
                if (child instanceof ParentComponent) {
                    ParentComponent parentComponent = (ParentComponent)child;
                    inspectorX += ((Insets)parentComponent.padding().get()).left();
                    inspectorY += ((Insets)parentComponent.padding().get()).top();
                }
            }
            class_2561 nameText = class_2561.method_30163((String)(child.getClass().getSimpleName() + (String)(child.id() != null ? " '" + child.id() + "'" : "")));
            class_5250 descriptor = class_2561.method_43470((String)(child.x() + "," + child.y() + " (" + child.width() + "," + child.height() + ") <" + margins.top() + "," + margins.bottom() + "," + margins.left() + "," + margins.right() + "> "));
            if (child instanceof ParentComponent) {
                ParentComponent parentComponent = (ParentComponent)child;
                Insets padding = (Insets)parentComponent.padding().get();
                descriptor.method_27693(" >" + padding.top() + "," + padding.bottom() + "," + padding.left() + "," + padding.right() + "<");
            }
            int width = Math.max(textRenderer.method_27525((class_5348)nameText), textRenderer.method_27525((class_5348)descriptor));
            this.method_48196(pipeline, inspectorX, inspectorY, inspectorX + width + 3, inspectorY + inspectorHeight, -1493172224);
            this.drawRectOutline(pipeline, inspectorX, inspectorY, width + 3, inspectorHeight, -1493172224);
            this.method_51439(textRenderer, nameText, inspectorX + 2, inspectorY + 2, -1, false);
            Objects.requireNonNull(textRenderer);
            this.method_51439(textRenderer, (class_2561)descriptor, inspectorX + 2, inspectorY + 9 + 2, -1, false);
        }
    }

    public static class UtilityScreen
    extends class_437 {
        private static UtilityScreen INSTANCE;
        private class_437 linkSourceScreen = null;

        private UtilityScreen() {
            super((class_2561)class_2561.method_43473());
        }

        public static UtilityScreen get() {
            if (INSTANCE == null) {
                INSTANCE = new UtilityScreen();
                class_310 client = class_310.method_1551();
                INSTANCE.method_25423(client, client.method_22683().method_4486(), client.method_22683().method_4502());
            }
            return INSTANCE;
        }

        public void setLinkSource(class_437 screen) {
            this.linkSourceScreen = screen;
        }

        public void captureLinkSource() {
            this.setLinkSource(this.field_22787.field_1755);
        }

        @ApiStatus.Internal
        @Nullable
        public class_437 getAndClearLinkSource() {
            class_437 source = this.linkSourceScreen;
            this.linkSourceScreen = null;
            return source;
        }

        public boolean method_25430(@Nullable class_2583 style) {
            return super.method_25430(style);
        }

        static {
            WindowResizeCallback.EVENT.register((client, window) -> {
                if (INSTANCE == null) {
                    return;
                }
                INSTANCE.method_25423(client, window.method_4486(), window.method_4502());
            });
        }
    }

    public static enum TextAnchor {
        TOP_RIGHT,
        BOTTOM_RIGHT,
        TOP_LEFT,
        BOTTOM_LEFT;

    }
}

