/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.debugify.client.mixins.basic.mc118740;

import com.mojang.authlib.GameProfile;
import dev.isxander.debugify.client.helpers.mc118740.LocalPlayerDuck;
import dev.isxander.debugify.fixes.BugFix;
import dev.isxander.debugify.fixes.FixCategory;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_3532;
import net.minecraft.class_746;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@BugFix(id="MC-118740", category=FixCategory.BASIC, env=BugFix.Env.CLIENT, modConflicts={"moulberrystweaks"}, description="Performing any right-click action silently resets the attack cooldown")
@Environment(value=EnvType.CLIENT)
@Mixin(value={class_746.class})
public abstract class LocalPlayerMixin
extends class_1657
implements LocalPlayerDuck {
    @Unique
    private int visualAttackStrengthTicker = 0;

    public LocalPlayerMixin(class_1937 level, GameProfile gameProfile) {
        super(level, gameProfile);
    }

    @Inject(method={"method_6104(Lnet/minecraft/class_1268;)V"}, at={@At(value="HEAD")})
    public void swing(class_1268 interactionHand, CallbackInfo ci) {
        this.visualAttackStrengthTicker = 0;
    }

    @Override
    public float debugify$getVisualAttackStrengthScale(float partialTick) {
        return class_3532.method_15363((float)(((float)this.visualAttackStrengthTicker + partialTick) / this.method_7279()), (float)0.0f, (float)1.0f);
    }

    @Override
    public void debugify$resetVisualAttackStrengthScale() {
        this.visualAttackStrengthTicker = 0;
    }

    @Override
    public void debugify$incrementVisualAttackStrengthScale() {
        ++this.visualAttackStrengthTicker;
    }
}

