/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.lithium.mixin.entity.equipment_tracking;

import com.llamalad7.mixinextras.injector.wrapmethod.WrapMethod;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import java.util.EnumMap;
import net.caffeinemc.mods.lithium.common.entity.EquipmentInfo;
import net.caffeinemc.mods.lithium.common.util.change_tracking.ChangePublisher;
import net.caffeinemc.mods.lithium.common.util.change_tracking.ChangeSubscriber;
import net.minecraft.class_10630;
import net.minecraft.class_1304;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_6880;
import net.minecraft.class_9304;
import net.minecraft.class_9334;
import net.minecraft.class_9701;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_10630.class})
public class EntityEquipmentMixin
implements EquipmentInfo,
ChangeSubscriber.CountChangeSubscriber<class_1799> {
    @Shadow
    @Final
    private EnumMap<class_1304, class_1799> field_55944;
    @Unique
    boolean shouldTickEnchantments = false;
    @Unique
    class_1799 recheckEnchantmentForStack = null;
    @Unique
    boolean hasUnsentEquipmentChanges = true;

    @Override
    public boolean lithium$shouldTickEnchantments() {
        this.processScheduledEnchantmentCheck(null);
        return this.shouldTickEnchantments;
    }

    @Override
    public boolean lithium$hasUnsentEquipmentChanges() {
        return this.hasUnsentEquipmentChanges;
    }

    @Override
    public void lithium$onEquipmentChangesSent() {
        this.hasUnsentEquipmentChanges = false;
    }

    @WrapMethod(method={"method_66660(Lnet/minecraft/class_1304;Lnet/minecraft/class_1799;)Lnet/minecraft/class_1799;"})
    private class_1799 updateOnSet(class_1304 equipmentSlot, class_1799 newStack, Operation<class_1799> original) {
        class_1799 oldStack = (class_1799)original.call(new Object[]{equipmentSlot, newStack});
        this.onEquipmentReplaced(oldStack, newStack);
        return oldStack;
    }

    @Inject(method={"method_67513(Lnet/minecraft/class_10630;)V"}, at={@At(value="HEAD")})
    private void updateBeforeSetAll(class_10630 entityEquipment, CallbackInfo ci) {
        this.onClear();
    }

    @Inject(method={"method_67515()V"}, at={@At(value="RETURN")})
    private void updateOnClear(CallbackInfo ci) {
        this.onClear();
    }

    @Unique
    private void onClear() {
        this.shouldTickEnchantments = false;
        this.recheckEnchantmentForStack = null;
        this.hasUnsentEquipmentChanges = true;
        for (class_1799 oldStack : this.field_55944.values()) {
            if (oldStack.method_7960()) continue;
            ((ChangePublisher)oldStack).lithium$unsubscribeWithData(this, 0);
        }
    }

    @Inject(method={"method_67513(Lnet/minecraft/class_10630;)V"}, at={@At(value="RETURN")})
    private void updateAfterSetAll(class_10630 entityEquipment, CallbackInfo ci) {
        for (class_1799 newStack : this.field_55944.values()) {
            if (newStack.method_7960()) continue;
            if (!this.shouldTickEnchantments) {
                this.shouldTickEnchantments = EntityEquipmentMixin.stackHasTickableEnchantment(newStack);
            }
            if (newStack.method_7960()) continue;
            ((ChangePublisher)newStack).lithium$subscribe(this, 0);
        }
    }

    @Unique
    private void onEquipmentReplaced(class_1799 oldStack, class_1799 newStack) {
        if (!this.shouldTickEnchantments) {
            if (this.recheckEnchantmentForStack == oldStack) {
                this.recheckEnchantmentForStack = null;
            }
            this.shouldTickEnchantments = EntityEquipmentMixin.stackHasTickableEnchantment(newStack);
        }
        this.hasUnsentEquipmentChanges = true;
        if (!oldStack.method_7960()) {
            ((ChangePublisher)oldStack).lithium$unsubscribeWithData(this, 0);
        }
        if (!newStack.method_7960()) {
            ((ChangePublisher)newStack).lithium$subscribe(this, 0);
        }
    }

    @Unique
    private static boolean stackHasTickableEnchantment(class_1799 stack) {
        class_9304 enchantments;
        if (!stack.method_7960() && (enchantments = (class_9304)stack.method_58694(class_9334.field_49633)) != null && !enchantments.method_57543()) {
            for (class_6880 enchantmentEntry : enchantments.method_57534()) {
                if (((class_1887)enchantmentEntry.comp_349()).method_60034(class_9701.field_51671).isEmpty()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void lithium$notify(@Nullable class_1799 publisher, int zero) {
        this.hasUnsentEquipmentChanges = true;
        if (!this.shouldTickEnchantments) {
            this.processScheduledEnchantmentCheck(publisher);
            this.scheduleEnchantmentCheck(publisher);
        }
    }

    @Unique
    private void scheduleEnchantmentCheck(@Nullable class_1799 toCheck) {
        this.recheckEnchantmentForStack = toCheck;
    }

    @Unique
    private void processScheduledEnchantmentCheck(@Nullable class_1799 ignoredStack) {
        if (this.recheckEnchantmentForStack != null && this.recheckEnchantmentForStack != ignoredStack) {
            this.shouldTickEnchantments = EntityEquipmentMixin.stackHasTickableEnchantment(this.recheckEnchantmentForStack);
            this.recheckEnchantmentForStack = null;
        }
    }

    @Override
    public void lithium$notifyCount(class_1799 publisher, int zero, int newCount) {
        if (newCount == 0) {
            ((ChangePublisher)publisher).lithium$unsubscribeWithData(this, zero);
        }
        this.onEquipmentReplaced(publisher, class_1799.field_8037);
    }

    @Override
    public void lithium$forceUnsubscribe(class_1799 publisher, int zero) {
        throw new UnsupportedOperationException();
    }
}

