/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.lithium.mixin.ai.non_poi_block_search;

import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongListIterator;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import net.caffeinemc.mods.lithium.common.ai.non_poi_block_search.CheckAndCacheBlockChecker;
import net.caffeinemc.mods.lithium.common.ai.non_poi_block_search.LithiumMoveToBlockGoal;
import net.caffeinemc.mods.lithium.common.ai.non_poi_block_search.NonPOISearchDistances;
import net.caffeinemc.mods.lithium.common.util.Pos;
import net.minecraft.class_1314;
import net.minecraft.class_1367;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2826;
import net.minecraft.class_4076;
import net.minecraft.class_4538;
import net.minecraft.class_5539;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={class_1367.class})
public abstract class MoveToBlockGoalMixin
implements LithiumMoveToBlockGoal {
    @Shadow
    @Final
    protected class_1314 field_6516;
    @Shadow
    @Final
    private int field_6510;
    @Shadow
    @Final
    private int field_6519;
    @Shadow
    protected int field_6515;
    @Shadow
    protected class_2338 field_6512;

    @Override
    public boolean lithium$findNearestBlock(Predicate<class_2680> requiredBlock, BiPredicate<class_2791, class_2338.class_2339> lithium$isValidTarget, boolean shouldChunkLoad) {
        class_2338 center = this.field_6516.method_24515().method_10069(0, -1, 0);
        class_1937 levelReader = this.field_6516.method_37908();
        CheckAndCacheBlockChecker checker = new CheckAndCacheBlockChecker(center, this.field_6510 - 1, this.field_6519, (class_4538)levelReader, requiredBlock, shouldChunkLoad);
        LongArrayList sortedChunksMaybeWithBlock = new LongArrayList(checker.getChunkSize());
        checker.initializeChunks(arg_0 -> sortedChunksMaybeWithBlock.addLast(arg_0));
        if (checker.shouldStop()) {
            return false;
        }
        int minY = Pos.BlockCoord.getMinY((class_5539)levelReader);
        int maxY = Pos.BlockCoord.getMaxYInclusive((class_5539)levelReader);
        if (!checker.hasUnloadedPossibleChunks()) {
            return this.lithium$chunkAwareSearch(center, lithium$isValidTarget, checker, sortedChunksMaybeWithBlock, minY, maxY);
        }
        return this.lithium$vanillaOrderSearch(center, lithium$isValidTarget, checker, minY, maxY);
    }

    @Unique
    private boolean lithium$vanillaOrderSearch(class_2338 center, BiPredicate<class_2791, class_2338.class_2339> lithium$isValidTarget, CheckAndCacheBlockChecker checker, int minY, int maxY) {
        class_2338.class_2339 currentPos = new class_2338.class_2339();
        int centerY = center.method_10264();
        int layer = this.field_6515;
        while (layer <= this.field_6519) {
            int y = centerY + layer;
            if (y >= minY && y <= maxY) {
                for (int ring = 0; ring < this.field_6510; ++ring) {
                    int dX = 0;
                    while (dX <= ring) {
                        int dZ;
                        int n = dZ = dX < ring && dX > -ring ? ring : 0;
                        while (dZ <= ring) {
                            class_2791 chunkAccess;
                            currentPos.method_25504((class_2382)center, dX, layer, dZ);
                            if (this.field_6516.method_18407((class_2338)currentPos) && checker.checkPosition((class_2338)currentPos) && lithium$isValidTarget.test(chunkAccess = checker.getCachedChunkAccess((class_2338)currentPos), currentPos)) {
                                this.field_6512 = currentPos;
                                return true;
                            }
                            dZ = dZ > 0 ? -dZ : 1 - dZ;
                        }
                        dX = dX > 0 ? -dX : 1 - dX;
                    }
                }
            }
            layer = layer > 0 ? -layer : 1 - layer;
        }
        return false;
    }

    @Unique
    private boolean lithium$chunkAwareSearch(class_2338 center, BiPredicate<class_2791, class_2338.class_2339> lithium$isValidTarget, CheckAndCacheBlockChecker checker, LongArrayList sortedChunksMaybeWithBlock, int minY, int maxY) {
        sortedChunksMaybeWithBlock.sort((chunkLong0, chunkLong1) -> NonPOISearchDistances.MoveToBlockGoalDistances.getMinimumSortOrderOfChunk(center, chunkLong0) - NonPOISearchDistances.MoveToBlockGoalDistances.getMinimumSortOrderOfChunk(center, chunkLong1));
        Predicate<class_2680> requiredBlock = checker.blockStatePredicate;
        int minSectionY = checker.minSectionY;
        class_2338.class_2339 foundPos = new class_2338.class_2339();
        class_2338.class_2339 currentPos = new class_2338.class_2339();
        int layer = this.field_6515;
        while (layer <= this.field_6519) {
            int y = center.method_10264() + layer;
            if (y >= minY && y <= maxY) {
                int chunkZ;
                long chunkPos;
                int chunkX;
                int chunkY = class_4076.method_18675((int)y);
                int ySectionIndex = chunkY - minSectionY;
                int closestFound = Integer.MAX_VALUE;
                int ringMax = this.field_6510 - 1;
                LongListIterator longListIterator = sortedChunksMaybeWithBlock.iterator();
                while (longListIterator.hasNext() && closestFound >= NonPOISearchDistances.MoveToBlockGoalDistances.getMinimumSortOrderOfChunk(center, chunkX = class_1923.method_8325((long)(chunkPos = ((Long)longListIterator.next()).longValue())), chunkZ = class_1923.method_8332((long)chunkPos))) {
                    if (!checker.checkCachedSection(chunkX, chunkY, chunkZ)) continue;
                    class_2791 chunkAccess = checker.getCachedChunkAccess(chunkPos);
                    int chunkBlockX = class_4076.method_18688((int)chunkX);
                    int xMin = Math.max(center.method_10263() - ringMax, chunkBlockX);
                    int xMax = Math.min(center.method_10263() + ringMax, chunkBlockX + 15);
                    int chunkBlockZ = class_4076.method_18688((int)chunkZ);
                    int zMin = Math.max(center.method_10260() - ringMax, chunkBlockZ);
                    int zMax = Math.min(center.method_10260() + ringMax, chunkBlockZ + 15);
                    class_2826 levelChunkSection = chunkAccess.method_12006()[ySectionIndex];
                    for (int z = zMin; z <= zMax; ++z) {
                        for (int x = xMin; x <= xMax; ++x) {
                            int dZ;
                            int dX = x - center.method_10263();
                            int ring = NonPOISearchDistances.MoveToBlockGoalDistances.getRing(dX, dZ = z - center.method_10260());
                            int currentDistance = NonPOISearchDistances.MoveToBlockGoalDistances.getVanillaSortOrderInt(ring, dX, dZ);
                            if (currentDistance >= closestFound || !this.field_6516.method_18407((class_2338)currentPos.method_10103(x, y, z)) || !requiredBlock.test(levelChunkSection.method_12254(x & 0xF, y & 0xF, z & 0xF)) || !lithium$isValidTarget.test(chunkAccess, currentPos)) continue;
                            ringMax = ring;
                            xMin = Math.max(center.method_10263() - ringMax, chunkBlockX);
                            xMax = Math.min(center.method_10263() + ringMax, chunkBlockX + 15);
                            zMax = Math.min(center.method_10260() + ringMax, chunkBlockZ + 15);
                            foundPos.method_10103(x, y, z);
                            closestFound = currentDistance;
                        }
                    }
                }
                if (closestFound < Integer.MAX_VALUE) {
                    this.field_6512 = foundPos;
                    return true;
                }
            }
            layer = layer > 0 ? -layer : 1 - layer;
        }
        return false;
    }
}

