/*
 * Decompiled with CFR 0.152.
 */
package jerozgen.languagereload.mixin;

import java.io.File;
import jerozgen.languagereload.LanguageReload;
import jerozgen.languagereload.config.Config;
import net.minecraft.class_2487;
import net.minecraft.class_310;
import net.minecraft.class_315;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_315.class})
abstract class GameOptionsMixin {
    @Shadow
    @Final
    private File field_1897;
    @Shadow
    public String field_1883;

    GameOptionsMixin() {
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    void onConstructed(class_310 client, File optionsFile, CallbackInfo ci) {
        if (!LanguageReload.shouldSetSystemLanguage) {
            GameOptionsMixin.checkConfigLanguage(this.field_1883);
        }
    }

    @Inject(method={"load"}, at={@At(value="HEAD")})
    void onLoad(CallbackInfo ci) {
        if (!this.field_1897.exists()) {
            LanguageReload.shouldSetSystemLanguage = true;
        }
    }

    @Inject(method={"update"}, at={@At(value="RETURN")})
    void onUpdate(class_2487 nbt, CallbackInfoReturnable<class_2487> cir) {
        String lang = ((class_2487)cir.getReturnValue()).method_68564("lang", "");
        if (lang.isEmpty()) {
            LanguageReload.shouldSetSystemLanguage = true;
        } else {
            GameOptionsMixin.checkConfigLanguage(lang);
        }
    }

    @Unique
    private static void checkConfigLanguage(String language) {
        Config config = Config.getInstance();
        if (!config.language.equals(language)) {
            LanguageReload.LOGGER.info("Game language ({}) and config language ({}) are different. Updating config", (Object)language, (Object)config.language);
            config.previousLanguage = config.language;
            config.previousFallbacks = config.fallbacks;
            config.language = language;
            config.fallbacks.clear();
            if (!language.equals("en_us")) {
                config.fallbacks.add("en_us");
            }
            Config.save();
        }
    }
}

