/*
 * Decompiled with CFR 0.152.
 */
package me.flashyreese.mods.sodiumextra.client.gui.options.control;

import java.util.function.Supplier;
import net.caffeinemc.mods.sodium.client.gui.options.Option;
import net.caffeinemc.mods.sodium.client.gui.options.control.Control;
import net.caffeinemc.mods.sodium.client.gui.options.control.ControlElement;
import net.caffeinemc.mods.sodium.client.gui.options.control.ControlValueFormatter;
import net.caffeinemc.mods.sodium.client.util.Dim2i;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_768;
import org.apache.commons.lang3.Validate;

public class DynamicSliderControl
implements Control<Integer> {
    private final Option<Integer> option;
    private final Supplier<Integer> min;
    private final Supplier<Integer> max;
    private final int interval;
    private final ControlValueFormatter mode;

    public DynamicSliderControl(Option<Integer> option, Supplier<Integer> min, Supplier<Integer> max, int interval, ControlValueFormatter mode) {
        Validate.isTrue((interval > 0 ? 1 : 0) != 0, (String)"The slider interval must be greater than zero", (Object[])new Object[0]);
        Validate.notNull((Object)mode, (String)"The slider mode must not be null", (Object[])new Object[0]);
        this.option = option;
        this.min = min;
        this.max = max;
        this.interval = interval;
        this.mode = mode;
    }

    public ControlElement<Integer> createElement(Dim2i dim) {
        int min = this.min.get();
        int max = this.max.get();
        int interval = this.interval;
        Validate.isTrue((max > min ? 1 : 0) != 0, (String)"The maximum value must be greater than the minimum value", (Object[])new Object[0]);
        Validate.isTrue(((max - min) % interval == 0 ? 1 : 0) != 0, (String)"The maximum value must be divisable by the interval", (Object[])new Object[0]);
        return new Button(this.option, dim, min, max, this.interval, this.mode);
    }

    public Option<Integer> getOption() {
        return this.option;
    }

    public int getMaxWidth() {
        return 170;
    }

    private static class Button
    extends ControlElement<Integer> {
        private static final int THUMB_WIDTH = 2;
        private static final int TRACK_HEIGHT = 1;
        private final class_768 sliderBounds;
        private final ControlValueFormatter formatter;
        private final int min;
        private final int max;
        private final int range;
        private final int interval;
        private int contentWidth;
        private double thumbPosition;
        private boolean sliderHeld;

        public Button(Option<Integer> option, Dim2i dim, int min, int max, int interval, ControlValueFormatter formatter) {
            super(option, dim);
            this.min = min;
            this.max = max;
            this.range = max - min;
            this.interval = interval;
            this.thumbPosition = this.getThumbPositionForValue((Integer)option.getValue());
            this.formatter = formatter;
            this.sliderBounds = new class_768(dim.getLimitX() - 96, dim.getCenterY() - 5, 90, 10);
            this.sliderHeld = false;
        }

        public void method_25394(class_332 graphics, int mouseX, int mouseY, float delta) {
            int sliderX = this.sliderBounds.method_3321();
            int sliderY = this.sliderBounds.method_3322();
            int sliderWidth = this.sliderBounds.method_3319();
            int sliderHeight = this.sliderBounds.method_3320();
            class_5250 label = this.formatter.format(((Integer)this.option.getValue()).intValue()).method_27661();
            if (!this.option.isAvailable()) {
                label.method_10862(class_2583.field_24360.method_10977(class_124.field_1080).method_10978(Boolean.valueOf(true)));
            }
            int labelWidth = this.font.method_27525((class_5348)label);
            boolean drawSlider = this.option.isAvailable() && (this.hovered || this.method_25370());
            this.contentWidth = drawSlider ? sliderWidth + labelWidth : labelWidth;
            super.method_25394(graphics, mouseX, mouseY, delta);
            if (drawSlider) {
                this.thumbPosition = this.getThumbPositionForValue((Integer)this.option.getValue());
                double thumbOffset = class_3532.method_15350((double)((double)(this.getIntValue() - this.min) / (double)this.range * (double)sliderWidth), (double)0.0, (double)sliderWidth);
                int thumbX = (int)((double)sliderX + thumbOffset - 2.0);
                int trackY = (int)((double)((float)sliderY + (float)sliderHeight / 2.0f) - 0.5);
                this.drawRect(graphics, thumbX, sliderY, thumbX + 4, sliderY + sliderHeight, -1);
                this.drawRect(graphics, sliderX, trackY, sliderX + sliderWidth, trackY + 1, -1);
                this.drawString(graphics, (class_2561)label, sliderX - labelWidth - 6, sliderY + sliderHeight / 2 - 4, -1);
            } else {
                this.drawString(graphics, (class_2561)label, sliderX + sliderWidth - labelWidth, sliderY + sliderHeight / 2 - 4, -1);
            }
        }

        public int getContentWidth() {
            return this.contentWidth;
        }

        public int getIntValue() {
            return this.min + this.interval * (int)Math.round(this.getSnappedThumbPosition() / (double)this.interval);
        }

        public double getSnappedThumbPosition() {
            return this.thumbPosition / (1.0 / (double)this.range);
        }

        public double getThumbPositionForValue(int value) {
            return (double)(value - this.min) * (1.0 / (double)this.range);
        }

        public boolean method_25402(double mouseX, double mouseY, int button) {
            this.sliderHeld = false;
            if (this.option.isAvailable() && button == 0 && this.dim.containsCursor(mouseX, mouseY)) {
                if (this.sliderBounds.method_3318((int)mouseX, (int)mouseY)) {
                    this.setValueFromMouse(mouseX);
                    this.sliderHeld = true;
                }
                return true;
            }
            return false;
        }

        private void setValueFromMouse(double d) {
            this.setValue((d - (double)this.sliderBounds.method_3321()) / (double)this.sliderBounds.method_3319());
        }

        public void setValue(double d) {
            this.thumbPosition = class_3532.method_15350((double)d, (double)0.0, (double)1.0);
            int value = this.getIntValue();
            if ((Integer)this.option.getValue() != value) {
                this.option.setValue((Object)value);
            }
        }

        public boolean method_25404(int keyCode, int scanCode, int modifiers) {
            if (!this.method_25370()) {
                return false;
            }
            if (keyCode == 263) {
                this.option.setValue((Object)class_3532.method_15340((int)((Integer)this.option.getValue() - this.interval), (int)this.min, (int)this.max));
                return true;
            }
            if (keyCode == 262) {
                this.option.setValue((Object)class_3532.method_15340((int)((Integer)this.option.getValue() + this.interval), (int)this.min, (int)this.max));
                return true;
            }
            return false;
        }

        public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
            if (this.option.isAvailable() && button == 0) {
                if (this.sliderHeld) {
                    this.setValueFromMouse(mouseX);
                }
                return true;
            }
            return false;
        }
    }
}

