/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.betterstats.api.client.gui.stats.panel;

import io.github.thecsdev.betterstats.api.client.gui.panel.BSComponentPanel;
import io.github.thecsdev.betterstats.api.client.gui.stats.widget.GeneralStatWidget;
import io.github.thecsdev.betterstats.api.registry.BSRegistries;
import io.github.thecsdev.betterstats.api.util.stats.SUItemStat;
import io.github.thecsdev.betterstats.api.util.stats.SUMobStat;
import io.github.thecsdev.tcdcommons.api.client.gui.TElement;
import io.github.thecsdev.tcdcommons.api.client.gui.other.TLabelElement;
import io.github.thecsdev.tcdcommons.api.util.TextUtils;
import io.github.thecsdev.tcdcommons.api.util.enumerations.HorizontalAlignment;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_3448;
import net.minecraft.class_3532;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public final class StatsSummaryPanel
extends BSComponentPanel {
    public static final int ENTRY_HEIGHT = GeneralStatWidget.HEIGHT;
    private final List<class_2561[]> entries = new ArrayList<class_2561[]>();
    protected int columnCount = 2;

    public StatsSummaryPanel(int x, int y, int width) {
        this(x, y, width, 10 + ENTRY_HEIGHT * 3);
    }

    public StatsSummaryPanel(int x, int y, int width, int height) {
        super(x, y, width, height);
        this.scrollFlags = 4;
        this.scrollPadding = 5;
    }

    public final void setColumnCount(int columnCount) {
        this.columnCount = class_3532.method_15340((int)columnCount, (int)1, (int)5);
        if (this.getParentTScreen() != null) {
            this.refresh();
        }
    }

    public final void clearEntries() {
        this.entries.clear();
    }

    public final void addEntry(@Nullable class_2561 left, @Nullable class_2561 right) {
        this.addEntry(left, null, right);
    }

    public final void addEntry(@Nullable class_2561 left, @Nullable class_2561 center, @Nullable class_2561 right) {
        this.entries.add(new class_2561[]{left, center, right});
    }

    public final void summarizeItemStats(Iterable<SUItemStat> itemStats) {
        this.clearEntries();
        LinkedHashMap<class_3448, Long> map = new LinkedHashMap<class_3448, Long>();
        for (class_3448 statType2 : class_7923.field_41193) {
            boolean isItem;
            class_2378 stR = statType2.method_14959();
            boolean isBlock = stR == class_7923.field_41175;
            boolean bl = isItem = stR == class_7923.field_41178;
            if (!isBlock && !isItem) continue;
            class_3448 statTypeO = statType2;
            long count = 0L;
            for (SUItemStat itemStat : itemStats) {
                count += (long)itemStat.getStatsProvider().getStatValue(statTypeO, isItem ? itemStat.getItem() : itemStat.getBlock());
            }
            map.put(statType2, count);
        }
        map.forEach((statType, statValue) -> this.addEntry(statType.method_30739(), (class_2561)TextUtils.literal((String)Long.toString(statValue))));
        if (this.getParentTScreen() != null) {
            this.refresh();
        }
    }

    public final void summarizeMobStats(Iterable<SUMobStat> mobStats) {
        this.clearEntries();
        LinkedHashMap<class_3448, Long> map = new LinkedHashMap<class_3448, Long>();
        for (class_3448 statType2 : class_7923.field_41193) {
            if (statType2.method_14959() != class_7923.field_41177) continue;
            class_3448 statTypeE = statType2;
            long count = 0L;
            for (SUMobStat mobStat : mobStats) {
                count += (long)mobStat.getStatsProvider().getStatValue(statTypeE, mobStat.getEntityType());
            }
            map.put(statTypeE, count);
        }
        map.forEach((statType, statValue) -> {
            class_2561 phrase = BSRegistries.getEntityStatTypePhrase(statType);
            this.addEntry(phrase, (class_2561)TextUtils.literal((String)Long.toString(statValue)));
        });
        if (this.getParentTScreen() != null) {
            this.refresh();
        }
    }

    protected final void init() {
        int sp = this.getScrollPadding();
        int entryWidth = (this.getWidth() - sp * 2) / Math.max(this.columnCount, 1);
        int row = 0;
        int column = 0;
        for (class_2561[] entry : this.entries) {
            int eX = sp + column * entryWidth;
            int eY = sp + row * ENTRY_HEIGHT;
            int ha = 0;
            for (class_2561 entryText : entry) {
                ++ha;
                if (entryText == null) continue;
                TLabelElement lbl = new TLabelElement(eX, eY, entryWidth, ENTRY_HEIGHT, entryText);
                lbl.setTextSideOffset(5);
                switch (ha) {
                    case 1: {
                        lbl.setTextHorizontalAlignment(HorizontalAlignment.LEFT);
                        break;
                    }
                    case 2: {
                        lbl.setTextHorizontalAlignment(HorizontalAlignment.CENTER);
                        break;
                    }
                    case 3: {
                        lbl.setTextHorizontalAlignment(HorizontalAlignment.RIGHT);
                        break;
                    }
                }
                this.addChild((TElement)lbl, true);
            }
            if (++column < this.columnCount) continue;
            column = 0;
            ++row;
        }
    }

    public final void autoHeight() {
        int rows = (int)Math.ceil((double)this.entries.size() / (double)Math.max(this.columnCount, 1));
        int height = rows * ENTRY_HEIGHT + this.getScrollPadding() * 2;
        this.setSize(this.getWidth(), height);
    }
}

