/*
 * Decompiled with CFR 0.152.
 */
package net.anvian.anvianslib.config;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import net.anvian.anvianslib.Constants;
import net.anvian.anvianslib.config.Config;
import net.anvian.anvianslib.platform.Services;
import net.anvian.anvianslib.util.LibUtil;

public class TelemetryConfigManager
extends Config {
    private static final Gson GSON = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).setPrettyPrinting().excludeFieldsWithModifiers(new int[]{2}).create();
    private static TelemetryConfig config;

    public static void initialize(File configDir) {
        configFile = new File(configDir, "telemetry.json");
        TelemetryConfigManager.loadConfig();
    }

    public static void loadConfig() {
        if (!configFile.exists()) {
            config = new TelemetryConfig();
            TelemetryConfigManager.saveConfig();
        } else {
            try (FileReader reader = new FileReader(configFile);){
                config = (TelemetryConfig)GSON.fromJson((Reader)reader, TelemetryConfig.class);
            }
            catch (IOException e) {
                Constants.LOG.error("Failed to load config");
                config = new TelemetryConfig();
            }
        }
    }

    public static void saveConfig() {
        try (FileWriter writer = new FileWriter(configFile);){
            GSON.toJson((Object)config, (Appendable)writer);
        }
        catch (IOException e) {
            Constants.LOG.error("Failed to save config");
        }
    }

    public static TelemetryConfig getConfig() {
        return config;
    }

    public static void sendTelemetryData(String modId, String modVersion, String game_version) {
        if (config != null && config.isEnableTelemetry()) {
            TelemetryConfigManager.sendTelemetryData(modId, modVersion, game_version, Services.PLATFORM.getPlatformName(), !Services.PLATFORM.isDevelopmentEnvironment());
        }
    }

    public static void sendTelemetryData(String modId, String modVersion) {
        if (config != null && config.isEnableTelemetry()) {
            TelemetryConfigManager.sendTelemetryData(modId, modVersion, LibUtil.getMinecraftVersion(), Services.PLATFORM.getPlatformName(), !Services.PLATFORM.isDevelopmentEnvironment());
        }
    }

    @Deprecated
    public static void sendTelemetryData(String modId, String modVersion, String game_version, String loader, Boolean isProduction) {
        if (config != null && config.isEnableTelemetry()) {
            try (HttpClient client = HttpClient.newHttpClient();){
                URI url = isProduction != false ? URI.create("https://anvian.net/telemetry/data") : URI.create("http://localhost:8082/telemetry/data");
                JsonObject jsonInput = new JsonObject();
                jsonInput.addProperty("mod_id", modId);
                jsonInput.addProperty("mod_version", modVersion);
                jsonInput.addProperty("game_version", game_version);
                jsonInput.addProperty("loader", loader);
                HttpRequest request = HttpRequest.newBuilder().uri(url).header("content-type", "application/json").POST(HttpRequest.BodyPublishers.ofString(jsonInput.toString())).build();
                HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
                Constants.LOG.info("Telemetry data sent: {}", (Object)response.statusCode());
            }
            catch (IOException | InterruptedException ignored) {
                Constants.LOG.error("Failed to send telemetry data from {}", (Object)modId);
            }
        }
    }

    public static class TelemetryConfig {
        public boolean enableTelemetry = true;

        public boolean isEnableTelemetry() {
            return this.enableTelemetry;
        }
    }
}

