/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.collective_common_neoforge.config;

import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import com.google.gson.stream.JsonWriter;
import com.natamus.collective_common_neoforge.functions.DataFunctions;
import com.natamus.collective_common_neoforge.functions.NumberFunctions;
import com.natamus.collective_common_neoforge.services.Services;
import java.awt.Color;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public abstract class DuskConfig {
    private static final Pattern INTEGER_ONLY = Pattern.compile("(-?[0-9]*)");
    private static final Pattern DECIMAL_ONLY = Pattern.compile("-?(\\d+\\.?\\d*|\\d*\\.?\\d+|\\.)");
    private static final Pattern HEXADECIMAL_ONLY = Pattern.compile("(-?[#0-9a-fA-F]*)");
    private static final HashMap<String, List<EntryInfo>> entryHashMap = new HashMap();
    public static final Map<String, Class<?>> configClass = new HashMap();
    private static final HashMap<String, String> modidToName = new HashMap();
    private static final HashMap<String, Path> pathMap = new HashMap();
    private static final HashMap<String, HashMap<String, List<String>>> modConfigMetaData = new HashMap();
    private static final Gson gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{128}).excludeFieldsWithModifiers(new int[]{2}).addSerializationExclusionStrategy((ExclusionStrategy)new HiddenAnnotationExclusionStrategy()).setPrettyPrinting().create();

    public static void init(String name, String modid, Class<?> config) {
        DuskConfig.init(name, modid, config, true);
    }

    public static void init(String name, String modid, Class<?> config, Boolean initial) {
        block17: {
            pathMap.put(modid, DataFunctions.getConfigDirectoryPath().resolve(modid + ".json5"));
            configClass.put(modid, config);
            modidToName.put(modid, name);
            entryHashMap.put(modid, new ArrayList());
            HashMap configMetaData = null;
            try {
                for (Field field : config.getDeclaredFields()) {
                    if (!field.getName().equals("configMetaData")) continue;
                    configMetaData = (HashMap)field.get(config);
                    break;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (configMetaData != null) {
                modConfigMetaData.put(modid, configMetaData);
            }
            for (Field field : config.getFields()) {
                EntryInfo info = new EntryInfo();
                if ((field.isAnnotationPresent(Entry.class) || field.isAnnotationPresent(Comment.class)) && !field.isAnnotationPresent(Server.class) && !field.isAnnotationPresent(Hidden.class) && Services.MODLOADER.isClientSide()) {
                    DuskConfig.initClient(modid, field, info, configMetaData);
                }
                if (field.isAnnotationPresent(Comment.class)) {
                    info.centered = field.getAnnotation(Comment.class).centered();
                }
                if (!field.isAnnotationPresent(Entry.class)) continue;
                try {
                    info.defaultValue = field.get(null);
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
            try {
                DuskConfig.loadJson(pathMap.get(modid), modid);
            }
            catch (Exception e) {
                DuskConfig.write(modid);
            }
            try {
                for (EntryInfo info : entryHashMap.get(modid)) {
                    if (!info.field.isAnnotationPresent(Entry.class)) continue;
                    try {
                        info.value = info.field.get(null);
                        info.tempValue = info.value.toString();
                    }
                    catch (IllegalAccessException illegalAccessException) {}
                }
            }
            catch (NullPointerException ex) {
                if (!initial.booleanValue()) break block17;
                DuskConfig.init(name, modid, config, false);
            }
        }
    }

    private static void initClient(String modid, Field field, EntryInfo info, HashMap<String, List<String>> configMetaData) {
        List<String> metaData;
        Class<?> type = field.getType();
        Entry e = field.getAnnotation(Entry.class);
        info.width = e != null ? e.width() : 0;
        info.field = field;
        info.id = modid;
        if (e != null) {
            if (!e.name().isEmpty()) {
                info.name = Component.translatable((String)e.name());
            }
            if (type == Integer.TYPE) {
                if (e.min() != Double.MIN_NORMAL) {
                    info.minValue = (int)e.min();
                    info.maxValue = (int)e.max();
                    info.minMaxSet = true;
                }
                DuskConfig.textField(modid, info, Integer::parseInt, INTEGER_ONLY, (int)e.min(), (int)e.max(), true);
            } else if (type == Float.TYPE) {
                if (e.min() != Double.MIN_NORMAL) {
                    info.minValue = (int)e.min();
                    info.maxValue = (int)e.max();
                    info.minMaxSet = true;
                }
                DuskConfig.textField(modid, info, Float::parseFloat, DECIMAL_ONLY, (float)e.min(), (float)e.max(), false);
            } else if (type == Double.TYPE) {
                if (e.min() != Double.MIN_NORMAL) {
                    info.minValue = (int)e.min();
                    info.maxValue = (int)e.max();
                    info.minMaxSet = true;
                }
                DuskConfig.textField(modid, info, Double::parseDouble, DECIMAL_ONLY, e.min(), e.max(), false);
            } else if (type == String.class || type == List.class) {
                info.max = e.max() == Double.MAX_VALUE ? Integer.MAX_VALUE : (int)e.max();
                DuskConfig.textField(modid, info, String::length, null, Math.min(e.min(), 0.0), Math.max(e.max(), 1.0), true);
            } else if (type == Boolean.TYPE) {
                Function<Object, Component> func = value -> Component.translatable((String)((Boolean)value != false ? "gui.yes" : "gui.no")).withStyle((Boolean)value != false ? ChatFormatting.GREEN : ChatFormatting.RED);
                info.widget = new AbstractMap.SimpleEntry<Button.OnPress, Function<Object, Component>>(button -> {
                    info.value = (Boolean)info.value == false;
                    button.setMessage((Component)func.apply(info.value));
                }, func);
            } else if (type.isEnum()) {
                List<?> values = Arrays.asList(field.getType().getEnumConstants());
                Function<Object, Component> func = value -> Component.translatable((String)(modid + ".duskconfig.enum." + type.getSimpleName() + "." + info.value.toString()));
                info.widget = new AbstractMap.SimpleEntry<Button.OnPress, Function<Object, Component>>(button -> {
                    int index = values.indexOf(info.value) + 1;
                    info.value = values.get(index >= values.size() ? 0 : index);
                    button.setMessage((Component)func.apply(info.value));
                }, func);
            }
        }
        String fieldname = field.getName();
        if (configMetaData != null && configMetaData.containsKey(fieldname) && !(metaData = configMetaData.get(fieldname)).isEmpty()) {
            info.description = metaData.get(0);
            if (metaData.size() > 1) {
                info.range = metaData.get(1);
            }
        }
        if (!entryHashMap.containsKey(modid)) {
            entryHashMap.put(modid, new ArrayList());
        }
        try {
            entryHashMap.get(modid).add(info);
        }
        catch (Exception e0) {
            try {
                entryHashMap.get(modid).add(info);
            }
            catch (Exception e1) {
                entryHashMap.put(modid, Arrays.asList(info));
            }
        }
    }

    private static void textField(String modid, EntryInfo info, Function<String, Number> f, Pattern pattern, double min, double max, boolean cast) {
        boolean isNumber = pattern != null;
        info.widget = (t, b) -> s -> {
            if (!((String)s).isEmpty() && isNumber && !pattern.matcher((CharSequence)s).matches()) {
                return false;
            }
            Number value = 0;
            boolean inLimits = false;
            info.error = null;
            if (!(isNumber && ((String)s).isEmpty() || ((String)s).equals("-") || ((String)s).equals("."))) {
                value = (Number)f.apply((String)s);
                boolean bl = inLimits = value.doubleValue() >= min && value.doubleValue() <= max;
                info.error = inLimits ? null : new AbstractMap.SimpleEntry<EditBox, MutableComponent>((EditBox)t, Component.literal((String)(value.doubleValue() < min ? "\u00a7cMinimum " + (isNumber ? "value" : "length") + (cast ? " is " + (int)min : " is " + min) : "\u00a7cMaximum " + (isNumber ? "value" : "length") + (cast ? " is " + (int)max : " is " + max))));
            }
            info.tempValue = s;
            t.setTextColor(inLimits ? -1 : -34953);
            info.inLimits = inLimits;
            b.active = entryHashMap.get(modid).stream().allMatch(e -> e.inLimits);
            if (inLimits && info.field.getType() != List.class) {
                info.value = isNumber ? value : s;
            } else if (inLimits) {
                if (((List)info.value).size() == info.index) {
                    ((List)info.value).add("");
                }
                ((List)info.value).set(info.index, Arrays.stream(info.tempValue.replace("[", "").replace("]", "").split(", ")).toList().getFirst());
            }
            if (info.field.getAnnotation(Entry.class).isColor()) {
                if (!((String)s).contains("#")) {
                    s = "#" + (String)s;
                }
                if (!HEXADECIMAL_ONLY.matcher((CharSequence)s).matches()) {
                    return false;
                }
                try {
                    info.colorButton.setMessage((Component)Component.literal((String)"\u2b1b").setStyle(Style.EMPTY.withColor(Color.decode(info.tempValue).getRGB())));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return true;
        };
    }

    public static void write(String modid) {
        Path path = DataFunctions.getConfigDirectoryPath().resolve(modid + ".json5");
        pathMap.put(modid, path);
        try {
            Class<?> cC;
            if (!Files.exists(path, new LinkOption[0])) {
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
                Files.createFile(path, new FileAttribute[0]);
            }
            if ((cC = configClass.get(modid)) == null) {
                return;
            }
            HashMap configMetaData = null;
            String lastline = "";
            StringBuilder json5 = new StringBuilder("{");
            for (Field field : cC.getDeclaredFields()) {
                if (!field.getName().equals("configMetaData")) continue;
                configMetaData = (HashMap)field.get(cC);
                break;
            }
            for (Field field : cC.getDeclaredFields()) {
                String fieldname = field.getName();
                if (fieldname.equals("configMetaData")) continue;
                if (configMetaData != null && configMetaData.containsKey(fieldname)) {
                    Entry e;
                    List metaData = (List)configMetaData.get(fieldname);
                    for (String metaDataValue : metaData) {
                        json5.append("\n\t// ").append(metaDataValue);
                    }
                    if (field.isAnnotationPresent(Entry.class) && (e = field.getAnnotation(Entry.class)).min() != Double.MIN_NORMAL) {
                        Object rangeValue = "min: " + e.min() + ", max: " + e.max();
                        if (field.getType() == Integer.TYPE) {
                            rangeValue = ((String)rangeValue).replace(".0", "");
                        }
                        json5.append("\n\t// ").append((String)rangeValue);
                    }
                }
                if (field.getType().isAssignableFrom(String.class)) {
                    Object fieldvalue = field.get(cC).toString();
                    if (!((String)fieldvalue).isEmpty()) {
                        if (((String)fieldvalue).charAt(0) != '\"') {
                            fieldvalue = "\"" + (String)fieldvalue + "\"";
                        }
                    } else {
                        fieldvalue = "\"\"";
                    }
                    json5.append("\n\t\"").append(fieldname).append("\": ").append((String)fieldvalue).append(",");
                    continue;
                }
                json5.append("\n\t\"").append(fieldname).append("\": ").append(field.get(cC)).append(",");
            }
            json5.setLength(json5.length() - 1);
            json5.append("\n}");
            Files.write(path, json5.toString().getBytes(), new OpenOption[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void loadJson(Path path, String modid) throws JsonSyntaxException, IOException {
        Path oldForgeTomlPath;
        boolean rewriteConfig = false;
        Path oldFabricJsonPath = DataFunctions.getConfigDirectoryPath().resolve(modid + ".json");
        if (Files.exists(oldFabricJsonPath, new LinkOption[0])) {
            Files.move(oldFabricJsonPath, path, StandardCopyOption.REPLACE_EXISTING);
            rewriteConfig = true;
        }
        if (Files.exists(oldForgeTomlPath = DataFunctions.getConfigDirectoryPath().resolve(modid + "-common.toml"), new LinkOption[0])) {
            DuskConfig.convertTomlToJson(oldForgeTomlPath, path);
            rewriteConfig = true;
        }
        if (!Files.exists(path, new LinkOption[0])) {
            rewriteConfig = true;
        }
        String content = Files.readString(path);
        content = Stream.of(content.split("\n")).filter(s -> !s.startsWith("\t//")).collect(Collectors.joining("\n"));
        gson.fromJson((Reader)new StringReader(content), configClass.get(modid));
        if (rewriteConfig) {
            DuskConfig.write(modid);
        }
    }

    private static void convertTomlToJson(Path oldTomlPath, Path newJsonPath) throws IOException {
        JsonWriter jsonWriter = new JsonWriter((Writer)new FileWriter(newJsonPath.toString()));
        jsonWriter.beginObject();
        String tomlContent = Files.readString(oldTomlPath, StandardCharsets.UTF_8);
        for (String line : tomlContent.split("\n")) {
            String[] linespl;
            if ((line = line.trim()).startsWith("[") || line.startsWith("#") || (linespl = line.split(" = ", 2)).length != 2) continue;
            String key = linespl[0];
            String rawValue = linespl[1].strip();
            if (rawValue.equals("true") || rawValue.equals("false")) {
                jsonWriter.name(key).value(Boolean.parseBoolean(rawValue));
                continue;
            }
            if (NumberFunctions.isNumeric(rawValue)) {
                if (rawValue.contains(".")) {
                    jsonWriter.name(key).value(Double.parseDouble(rawValue));
                    continue;
                }
                jsonWriter.name(key).value((long)Integer.parseInt(rawValue));
                continue;
            }
            jsonWriter.name(key).value(rawValue);
        }
        jsonWriter.endObject();
        jsonWriter.close();
        Files.delete(oldTomlPath);
    }

    public static class EntryInfo {
        Field field;
        Object widget;
        int width;
        double minValue;
        double maxValue;
        boolean minMaxSet = false;
        int max;
        boolean centered;
        Map.Entry<EditBox, Component> error;
        Object defaultValue;
        Object value;
        String tempValue;
        boolean inLimits = true;
        String id;
        Component name;
        String description = "";
        String range = "";
        int index;
        AbstractWidget colorButton;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Entry {
        public int width() default 100;

        public double min() default 2.2250738585072014E-308;

        public double max() default 1.7976931348623157E308;

        public String name() default "";

        public boolean isColor() default false;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Comment {
        public boolean centered() default false;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Server {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Hidden {
    }

    public static class HiddenAnnotationExclusionStrategy
    implements ExclusionStrategy {
        public boolean shouldSkipClass(Class<?> clazz) {
            return false;
        }

        public boolean shouldSkipField(FieldAttributes fieldAttributes) {
            return fieldAttributes.getAnnotation(Entry.class) == null;
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Client {
    }

    public static class ButtonEntry
    extends ContainerObjectSelectionList.Entry<ButtonEntry> {
        private static final Font font = Minecraft.getInstance().font;
        public final List<AbstractWidget> buttons;
        private final Component text;
        public final EntryInfo info;
        private final List<AbstractWidget> children = new ArrayList<AbstractWidget>();
        public static final Map<AbstractWidget, Component> buttonsWithComponent = new HashMap<AbstractWidget, Component>();

        private ButtonEntry(List<AbstractWidget> buttons, Component text, EntryInfo info) {
            if (!buttons.isEmpty()) {
                buttonsWithComponent.put(buttons.getFirst(), text);
            }
            this.buttons = buttons;
            this.text = text;
            this.info = info;
            this.children.addAll(buttons);
        }

        public static ButtonEntry create(List<AbstractWidget> buttons, Component text, EntryInfo info) {
            return new ButtonEntry(buttons, text, info);
        }

        public void render(@NotNull GuiGraphics guiGraphics, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            this.buttons.forEach(b -> {
                b.setY(y);
                b.render(guiGraphics, mouseX, mouseY, tickDelta);
            });
            if (!(this.text == null || this.text.getString().contains("spacer") && this.buttons.isEmpty())) {
                if (this.info.centered) {
                    guiGraphics.drawString(font, this.text, (int)((float)Minecraft.getInstance().getWindow().getGuiScaledWidth() / 2.0f - (float)font.width((FormattedText)this.text) / 2.0f), y + 5, -1);
                } else {
                    guiGraphics.drawString(font, this.text, 12, y + 5, -1);
                }
            }
        }

        @NotNull
        public List<? extends GuiEventListener> children() {
            return this.children;
        }

        @NotNull
        public List<? extends NarratableEntry> narratables() {
            return this.children;
        }
    }

    public static class DuskConfigListWidget
    extends ContainerObjectSelectionList<ButtonEntry> {
        Font font;

        public DuskConfigListWidget(Minecraft client, int width, int height, int y, int itemHeight, int m) {
            super(client, width, height - 68, y, m);
            this.centerListVertically = false;
            this.font = client.font;
        }

        public int scrollBarX() {
            return this.width - 7;
        }

        public void addButton(List<AbstractWidget> buttons, Component text, EntryInfo info) {
            this.addEntry((AbstractSelectionList.Entry)ButtonEntry.create(buttons, text, info));
        }

        public int getRowWidth() {
            return 10000;
        }

        public Optional<AbstractWidget> getHoveredButton(double mouseX, double mouseY) {
            for (ButtonEntry buttonEntry : this.children()) {
                if (buttonEntry.buttons.isEmpty() || !buttonEntry.buttons.getFirst().isMouseOver(mouseX, mouseY)) continue;
                return Optional.of(buttonEntry.buttons.getFirst());
            }
            return Optional.empty();
        }
    }

    public static class DuskConfigScreen
    extends Screen {
        public final String translationPrefix;
        public final Screen parent;
        public final String modid;
        public DuskConfigListWidget list;
        public boolean reload = false;

        protected DuskConfigScreen(Screen parent, String modid) {
            super((Component)Component.literal((String)(StringUtils.capitalize((String)modidToName.get(modid)) + " Config")));
            this.parent = parent;
            this.modid = modid;
            this.translationPrefix = modid + ".duskconfig.";
        }

        public static Screen getScreen(Screen parent, String modid) {
            return new DuskConfigScreen(parent, modid);
        }

        public void renderBackground(@NotNull GuiGraphics guiGraphics, int a, int b, float c) {
            if (this.minecraft.level == null) {
                this.renderPanorama(guiGraphics, c);
            }
            this.renderBlurredBackground(guiGraphics);
        }

        public void tick() {
            super.tick();
            for (EntryInfo info : entryHashMap.get(this.modid)) {
                try {
                    info.field.set(null, info.value);
                }
                catch (IllegalAccessException illegalAccessException) {}
            }
            this.updateResetButtons();
        }

        public void updateResetButtons() {
            if (this.list != null) {
                for (ButtonEntry entry : this.list.children()) {
                    AbstractWidget abstractWidget;
                    if (entry.buttons == null || entry.buttons.size() <= 1 || !((abstractWidget = entry.buttons.get(1)) instanceof Button)) continue;
                    Button button = (Button)abstractWidget;
                    button.active = !Objects.equals(entry.info.value.toString(), entry.info.defaultValue.toString());
                }
            }
        }

        public void loadValues() {
            try {
                DuskConfig.loadJson(pathMap.get(this.modid), this.modid);
            }
            catch (Exception e) {
                DuskConfig.write(this.modid);
            }
            for (EntryInfo info : entryHashMap.get(this.modid)) {
                if (!info.field.isAnnotationPresent(Entry.class)) continue;
                try {
                    info.value = info.field.get(null);
                    info.tempValue = info.value.toString();
                }
                catch (IllegalAccessException illegalAccessException) {}
            }
        }

        public void init() {
            super.init();
            if (!this.reload) {
                this.loadValues();
            }
            this.addRenderableWidget((GuiEventListener)Button.builder((Component)CommonComponents.GUI_CANCEL, button -> {
                this.loadValues();
                Objects.requireNonNull(this.minecraft).setScreen(this.parent);
            }).pos(this.width / 2 - 154, this.height - 28).size(150, 20).build());
            Button done = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)CommonComponents.GUI_DONE, button -> {
                for (EntryInfo info : entryHashMap.get(this.modid)) {
                    if (!info.id.equals(this.modid)) continue;
                    try {
                        info.field.set(null, info.value);
                    }
                    catch (IllegalAccessException illegalAccessException) {}
                }
                DuskConfig.write(this.modid);
                Objects.requireNonNull(this.minecraft).setScreen(this.parent);
            }).pos(this.width / 2 + 4, this.height - 28).size(150, 20).build());
            this.list = new DuskConfigListWidget(this.minecraft, this.width, this.height, 32, this.height - 32, 25);
            this.addWidget((GuiEventListener)this.list);
            for (EntryInfo info : entryHashMap.get(this.modid)) {
                if (info.id.equals(this.modid)) {
                    String namestring = info.field.getName();
                    namestring = namestring.replace("_", " ").strip();
                    String[] nsspl = namestring.split("(?<=.)(?=\\p{Lu})");
                    ArrayList<Object> correctNameParts = new ArrayList();
                    try {
                        for (int i = 0; i < nsspl.length; ++i) {
                            StringBuilder namePart = new StringBuilder(nsspl[i]);
                            if (namePart.toString().strip().length() == 1) {
                                boolean append = false;
                                while (i < nsspl.length) {
                                    if (append) {
                                        namePart.append(nsspl[i]);
                                    }
                                    if (i + 1 >= nsspl.length || nsspl[i + 1].strip().length() != 1) break;
                                    append = true;
                                    ++i;
                                }
                            }
                            if (correctNameParts.contains(namePart.toString())) continue;
                            correctNameParts.add(namePart.toString());
                        }
                    }
                    catch (Exception ex) {
                        correctNameParts = new ArrayList<String>(Arrays.asList(nsspl));
                    }
                    String formattedName = StringUtils.capitalize((String)String.join((CharSequence)" ", correctNameParts));
                    MutableComponent name = Component.literal((String)formattedName);
                    Button resetButton = Button.builder((Component)Component.literal((String)"Reset").withStyle(ChatFormatting.RED), button -> {
                        info.value = info.defaultValue;
                        info.tempValue = info.defaultValue.toString();
                        info.index = 0;
                        double scrollAmount = this.list.scrollAmount();
                        this.reload = true;
                        Objects.requireNonNull(this.minecraft).setScreen((Screen)this);
                        this.list.setScrollAmount(scrollAmount);
                    }).pos(this.width - 205, 0).size(40, 20).build();
                    if (info.widget instanceof Map.Entry) {
                        widget = (Map.Entry)info.widget;
                        if (info.field.getType().isEnum()) {
                            widget.setValue(value -> Component.translatable((String)(this.translationPrefix + "enum." + info.field.getType().getSimpleName() + "." + info.value.toString())));
                        }
                        this.list.addButton(List.of(Button.builder((Component)((Component)((Function)widget.getValue()).apply(info.value)), (Button.OnPress)((Button.OnPress)widget.getKey())).pos(this.width - 160, 0).size(150, 20).build(), resetButton), (Component)name, info);
                    } else if (info.field.getType() == List.class) {
                        if (!this.reload) {
                            info.index = 0;
                        }
                        widget = new EditBox(this.font, this.width - 160, 0, 150, 20, null);
                        widget.setMaxLength(Integer.MAX_VALUE);
                        if (info.index < ((List)info.value).size()) {
                            widget.setValue(String.valueOf(((List)info.value).get(info.index)));
                        } else {
                            widget.setValue("");
                        }
                        processor = (Predicate)((BiFunction)info.widget).apply(widget, done);
                        widget.setFilter(processor);
                        resetButton.setWidth(20);
                        resetButton.setMessage((Component)Component.literal((String)"R").withStyle(ChatFormatting.RED));
                        Button cycleButton = Button.builder((Component)Component.literal((String)String.valueOf(info.index)), button -> {
                            ((List)info.value).remove("");
                            double scrollAmount = this.list.scrollAmount();
                            this.reload = true;
                            ++info.index;
                            if (info.index > ((List)info.value).size()) {
                                info.index = 0;
                            }
                            Objects.requireNonNull(this.minecraft).setScreen((Screen)this);
                            this.list.setScrollAmount(scrollAmount);
                        }).pos(this.width - 185, 0).size(20, 20).build();
                        this.list.addButton(List.of(widget, resetButton, cycleButton), (Component)name, info);
                    } else if (info.widget != null) {
                        widget = new EditBox(this.font, this.width - 160, 0, 150, 20, null);
                        widget.setMaxLength(Integer.MAX_VALUE);
                        widget.setValue(info.tempValue);
                        processor = (Predicate)((BiFunction)info.widget).apply(widget, done);
                        widget.setFilter(processor);
                        if (info.field.getAnnotation(Entry.class).isColor()) {
                            resetButton.setWidth(20);
                            resetButton.setMessage((Component)Component.literal((String)"R").withStyle(ChatFormatting.RED));
                            Button colorButton = Button.builder((Component)Component.literal((String)"\u2b1b"), button -> {}).pos(this.width - 185, 0).size(20, 20).build();
                            try {
                                colorButton.setMessage((Component)Component.literal((String)"\u2b1b").setStyle(Style.EMPTY.withColor(Color.decode(info.tempValue).getRGB())));
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            info.colorButton = colorButton;
                            colorButton.active = false;
                            this.list.addButton(List.of(widget, resetButton, colorButton), (Component)name, info);
                        } else {
                            this.list.addButton(List.of(widget, resetButton), (Component)name, info);
                        }
                    } else {
                        this.list.addButton(List.of(), (Component)name, info);
                    }
                    Object rangeValue = "";
                    if (info.minMaxSet) {
                        rangeValue = "min: " + info.minValue + ", max: " + info.maxValue;
                        if (info.field.getType() == Integer.TYPE) {
                            rangeValue = ((String)rangeValue).replace(".0", "");
                        }
                    } else if (!info.range.isEmpty()) {
                        rangeValue = info.range;
                    }
                    if (!((String)rangeValue).isEmpty()) {
                        EditBox label = new EditBox(this.font, this.width - 155, 0, 145, 20, null);
                        label.setValue((String)rangeValue);
                        label.setBordered(false);
                        label.setEditable(false);
                        this.list.addButton(List.of(label), (Component)Component.literal((String)""), info);
                    }
                }
                this.updateResetButtons();
            }
        }

        public void render(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
            super.render(guiGraphics, mouseX, mouseY, delta);
            if (this.minecraft == null || Objects.requireNonNull(this.minecraft).level == null) {
                // empty if block
            }
            this.list.render(guiGraphics, mouseX, mouseY, delta);
            guiGraphics.drawCenteredString(this.font, this.title, this.width / 2, 15, -1);
        }
    }
}

