/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.voice.client;

import de.maxhenkel.voicechat.VoicechatClient;
import de.maxhenkel.voicechat.gui.onboarding.OnboardingManager;
import de.maxhenkel.voicechat.intercompatibility.ClientCompatibilityManager;
import de.maxhenkel.voicechat.plugins.ClientPluginManager;
import de.maxhenkel.voicechat.voice.client.ClientManager;
import de.maxhenkel.voicechat.voice.client.ClientPlayerStateManager;
import de.maxhenkel.voicechat.voice.client.ClientVoicechat;
import de.maxhenkel.voicechat.voice.client.GroupChatManager;
import de.maxhenkel.voicechat.voice.client.MicrophoneActivationType;
import java.util.UUID;
import net.minecraft.class_10017;
import net.minecraft.class_10055;
import net.minecraft.class_10799;
import net.minecraft.class_1297;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5348;
import org.joml.Quaternionfc;

public class RenderEvents {
    private static final class_2960 MICROPHONE_ICON = class_2960.method_60655((String)"voicechat", (String)"textures/icons/microphone.png");
    private static final class_2960 WHISPER_MICROPHONE_ICON = class_2960.method_60655((String)"voicechat", (String)"textures/icons/microphone_whisper.png");
    private static final class_2960 MICROPHONE_OFF_ICON = class_2960.method_60655((String)"voicechat", (String)"textures/icons/microphone_off.png");
    private static final class_2960 SPEAKER_ICON = class_2960.method_60655((String)"voicechat", (String)"textures/icons/speaker.png");
    private static final class_2960 WHISPER_SPEAKER_ICON = class_2960.method_60655((String)"voicechat", (String)"textures/icons/speaker_whisper.png");
    private static final class_2960 SPEAKER_OFF_ICON = class_2960.method_60655((String)"voicechat", (String)"textures/icons/speaker_off.png");
    private static final class_2960 DISCONNECT_ICON = class_2960.method_60655((String)"voicechat", (String)"textures/icons/disconnected.png");
    private static final class_2960 GROUP_ICON = class_2960.method_60655((String)"voicechat", (String)"textures/icons/group.png");
    private final class_310 minecraft = class_310.method_1551();

    public RenderEvents() {
        ClientCompatibilityManager.INSTANCE.onRenderNamePlate(this::onRenderName);
        ClientCompatibilityManager.INSTANCE.onRenderHUD(this::onRenderHUD);
    }

    private void onRenderHUD(class_332 guiGraphics, float tickDelta) {
        if (!this.shouldShowIcons()) {
            return;
        }
        if (VoicechatClient.CLIENT_CONFIG.hideIcons.get().booleanValue()) {
            return;
        }
        if (!VoicechatClient.CLIENT_CONFIG.showHudIcons.get().booleanValue()) {
            return;
        }
        ClientPlayerStateManager manager = ClientManager.getPlayerStateManager();
        ClientVoicechat client = ClientManager.getClient();
        if (manager.isDisconnected() && this.isStartup()) {
            return;
        }
        if (manager.isDisconnected()) {
            this.renderIcon(guiGraphics, DISCONNECT_ICON);
        } else if (manager.isDisabled()) {
            this.renderIcon(guiGraphics, SPEAKER_OFF_ICON);
        } else if (manager.isMuted() && VoicechatClient.CLIENT_CONFIG.microphoneActivationType.get().equals((Object)MicrophoneActivationType.VOICE)) {
            this.renderIcon(guiGraphics, MICROPHONE_OFF_ICON);
        } else if (client != null && client.getMicThread() != null) {
            if (client.getMicThread().isWhispering()) {
                this.renderIcon(guiGraphics, WHISPER_MICROPHONE_ICON);
            } else if (client.getMicThread().isTalking()) {
                this.renderIcon(guiGraphics, MICROPHONE_ICON);
            }
        }
        if (manager.getGroupID() != null && VoicechatClient.CLIENT_CONFIG.showGroupHud.get().booleanValue()) {
            GroupChatManager.renderIcons(guiGraphics);
        }
    }

    private boolean isStartup() {
        ClientVoicechat client = ClientManager.getClient();
        return client != null && System.currentTimeMillis() - client.getStartTime() < 5000L;
    }

    private void renderIcon(class_332 guiGraphics, class_2960 texture) {
        guiGraphics.method_51448().pushMatrix();
        int posX = VoicechatClient.CLIENT_CONFIG.hudIconPosX.get();
        int posY = VoicechatClient.CLIENT_CONFIG.hudIconPosY.get();
        if (posX < 0) {
            guiGraphics.method_51448().translate((float)this.minecraft.method_22683().method_4486(), 0.0f);
        }
        if (posY < 0) {
            guiGraphics.method_51448().translate(0.0f, (float)this.minecraft.method_22683().method_4502());
        }
        guiGraphics.method_51448().translate((float)posX, (float)posY);
        float scale = VoicechatClient.CLIENT_CONFIG.hudIconScale.get().floatValue();
        guiGraphics.method_51448().scale(scale, scale);
        guiGraphics.method_25290(class_10799.field_56883, texture, posX < 0 ? -16 : 0, posY < 0 ? -16 : 0, 0.0f, 0.0f, 16, 16, 16, 16);
        guiGraphics.method_51448().popMatrix();
    }

    private void onRenderName(class_10017 renderState, class_2561 component, class_4587 stack, class_4597 vertexConsumers, int light) {
        if (component == null) {
            return;
        }
        if (!this.shouldShowIcons()) {
            return;
        }
        if (VoicechatClient.CLIENT_CONFIG.hideIcons.get().booleanValue()) {
            return;
        }
        if (!VoicechatClient.CLIENT_CONFIG.showNametagIcons.get().booleanValue()) {
            return;
        }
        if (this.minecraft.field_1724 == null || this.minecraft.field_1687 == null) {
            return;
        }
        if (!(renderState instanceof class_10055)) {
            return;
        }
        class_10055 playerRenderState = (class_10055)renderState;
        class_1297 entity = this.minecraft.field_1687.method_8469(playerRenderState.field_53528);
        if (entity == null) {
            return;
        }
        if (this.minecraft.field_1724.equals((Object)entity)) {
            return;
        }
        if (!this.minecraft.field_1690.field_1842) {
            ClientPlayerStateManager manager = ClientManager.getPlayerStateManager();
            ClientVoicechat client = ClientManager.getClient();
            UUID entityId = entity.method_5667();
            UUID groupId = manager.getGroup(entityId);
            if (client != null && client.getTalkCache().isWhispering(entityId)) {
                this.renderPlayerIcon(entityId, renderState, component, WHISPER_SPEAKER_ICON, stack, vertexConsumers, light);
            } else if (client != null && client.getTalkCache().isTalking(entityId)) {
                this.renderPlayerIcon(entityId, renderState, component, SPEAKER_ICON, stack, vertexConsumers, light);
            } else if (manager.isPlayerDisconnected(entityId)) {
                this.renderPlayerIcon(entityId, renderState, component, DISCONNECT_ICON, stack, vertexConsumers, light);
            } else if (groupId != null && !groupId.equals(manager.getGroupID())) {
                this.renderPlayerIcon(entityId, renderState, component, GROUP_ICON, stack, vertexConsumers, light);
            } else if (manager.isPlayerDisabled(entityId)) {
                this.renderPlayerIcon(entityId, renderState, component, SPEAKER_OFF_ICON, stack, vertexConsumers, light);
            }
        }
    }

    private void renderPlayerIcon(UUID entityId, class_10017 renderState, class_2561 component, class_2960 texture, class_4587 poseStack, class_4597 buffer, int light) {
        if (renderState.field_53338 == null) {
            return;
        }
        if (!ClientPluginManager.instance().shouldRenderPlayerIcons(entityId)) {
            return;
        }
        poseStack.method_22903();
        poseStack.method_22904(renderState.field_53338.field_1352, renderState.field_53338.field_1351 + 0.5, renderState.field_53338.field_1350);
        poseStack.method_22907((Quaternionfc)this.minecraft.method_1561().method_24197());
        poseStack.method_22905(0.025f, -0.025f, 0.025f);
        poseStack.method_22904(0.0, -1.0, 0.0);
        float offset = this.minecraft.field_1772.method_27525((class_5348)component) / 2 + 2;
        class_4588 builder = buffer.getBuffer(class_1921.method_23028((class_2960)texture));
        int alpha = 32;
        if (renderState.field_53334) {
            RenderEvents.vertex(builder, poseStack, offset, 10.0f, 0.0f, 0.0f, 1.0f, alpha, light);
            RenderEvents.vertex(builder, poseStack, offset + 10.0f, 10.0f, 0.0f, 1.0f, 1.0f, alpha, light);
            RenderEvents.vertex(builder, poseStack, offset + 10.0f, 0.0f, 0.0f, 1.0f, 0.0f, alpha, light);
            RenderEvents.vertex(builder, poseStack, offset, 0.0f, 0.0f, 0.0f, 0.0f, alpha, light);
        } else {
            RenderEvents.vertex(builder, poseStack, offset, 10.0f, 0.0f, 0.0f, 1.0f, light);
            RenderEvents.vertex(builder, poseStack, offset + 10.0f, 10.0f, 0.0f, 1.0f, 1.0f, light);
            RenderEvents.vertex(builder, poseStack, offset + 10.0f, 0.0f, 0.0f, 1.0f, 0.0f, light);
            RenderEvents.vertex(builder, poseStack, offset, 0.0f, 0.0f, 0.0f, 0.0f, light);
            class_4588 builderSeeThrough = buffer.getBuffer(class_1921.method_23030((class_2960)texture));
            RenderEvents.vertex(builderSeeThrough, poseStack, offset, 10.0f, 0.0f, 0.0f, 1.0f, alpha, light);
            RenderEvents.vertex(builderSeeThrough, poseStack, offset + 10.0f, 10.0f, 0.0f, 1.0f, 1.0f, alpha, light);
            RenderEvents.vertex(builderSeeThrough, poseStack, offset + 10.0f, 0.0f, 0.0f, 1.0f, 0.0f, alpha, light);
            RenderEvents.vertex(builderSeeThrough, poseStack, offset, 0.0f, 0.0f, 0.0f, 0.0f, alpha, light);
        }
        poseStack.method_22909();
    }

    private boolean shouldShowIcons() {
        if (OnboardingManager.isOnboarding()) {
            return false;
        }
        if (ClientManager.getClient() != null && ClientManager.getClient().getConnection() != null && ClientManager.getClient().getConnection().isInitialized()) {
            return true;
        }
        return this.minecraft.method_1576() == null || this.minecraft.method_1576().method_3860();
    }

    private static void vertex(class_4588 builder, class_4587 matrixStack, float x, float y, float z, float u, float v, int light) {
        RenderEvents.vertex(builder, matrixStack, x, y, z, u, v, 255, light);
    }

    private static void vertex(class_4588 builder, class_4587 matrixStack, float x, float y, float z, float u, float v, int alpha, int light) {
        class_4587.class_4665 entry = matrixStack.method_23760();
        builder.method_22918(entry.method_23761(), x, y, z).method_1336(255, 255, 255, alpha).method_22913(u, v).method_22922(class_4608.field_21444).method_60803(light).method_60831(entry, 0.0f, 0.0f, -1.0f);
    }
}

