/*
 * Decompiled with CFR 0.152.
 */
package me.flashyreese.mods.reeses_sodium_options.client.gui.frame.components;

import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import me.flashyreese.mods.reeses_sodium_options.client.gui.OptionExtended;
import me.flashyreese.mods.reeses_sodium_options.client.gui.SodiumVideoOptionsScreen;
import me.flashyreese.mods.reeses_sodium_options.util.StringUtils;
import net.caffeinemc.mods.sodium.client.gui.options.Option;
import net.caffeinemc.mods.sodium.client.gui.options.OptionPage;
import net.caffeinemc.mods.sodium.client.gui.widgets.AbstractWidget;
import net.caffeinemc.mods.sodium.client.util.Dim2i;
import net.minecraft.class_10799;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_3544;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5481;
import net.minecraft.class_8016;
import net.minecraft.class_8023;
import net.minecraft.class_8030;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SearchTextFieldComponent
extends AbstractWidget {
    protected final Dim2i dim;
    protected final List<OptionPage> pages;
    private final class_327 font;
    private final Predicate<String> textPredicate;
    private final BiFunction<String, Integer, class_5481> renderTextProvider;
    private final AtomicReference<class_2561> tabFrameSelectedTab;
    private final AtomicReference<Integer> tabFrameScrollBarOffset;
    private final AtomicReference<Integer> optionPageScrollBarOffset;
    private final int tabDimHeight;
    private final SodiumVideoOptionsScreen sodiumVideoOptionsScreen;
    private final AtomicReference<String> lastSearch;
    private final AtomicReference<Integer> lastSearchIndex;
    protected boolean selecting;
    protected String text;
    protected int maxLength;
    protected boolean visible;
    protected boolean editable;
    private int firstCharacterIndex;
    private int selectionStart;
    private int selectionEnd;
    private int lastCursorPosition;
    private static final long CURSOR_ANIMATION_DURATION = 750L;
    private long nextCursorUpdate;
    private boolean currentCursorState;
    private float currentCursorAlpha;

    public SearchTextFieldComponent(Dim2i dim, List<OptionPage> pages, AtomicReference<class_2561> tabFrameSelectedTab, AtomicReference<Integer> tabFrameScrollBarOffset, AtomicReference<Integer> optionPageScrollBarOffset, int tabDimHeight, SodiumVideoOptionsScreen sodiumVideoOptionsScreen, AtomicReference<String> lastSearch, AtomicReference<Integer> lastSearchIndex) {
        this.font = class_310.method_1551().field_1772;
        this.textPredicate = Objects::nonNull;
        this.renderTextProvider = (string, firstCharacterIndex) -> class_5481.method_30747((String)string, (class_2583)class_2583.field_24360);
        this.text = "";
        this.maxLength = 100;
        this.visible = true;
        this.editable = true;
        this.lastCursorPosition = this.getCursor();
        this.dim = dim;
        this.pages = pages;
        this.tabFrameSelectedTab = tabFrameSelectedTab;
        this.tabFrameScrollBarOffset = tabFrameScrollBarOffset;
        this.optionPageScrollBarOffset = optionPageScrollBarOffset;
        this.tabDimHeight = tabDimHeight;
        this.sodiumVideoOptionsScreen = sodiumVideoOptionsScreen;
        this.lastSearch = lastSearch;
        this.lastSearchIndex = lastSearchIndex;
        if (!lastSearch.get().trim().isEmpty()) {
            this.write(lastSearch.get());
        }
    }

    public void method_25394(@NotNull class_332 guiGraphics, int mouseX, int mouseY, float delta) {
        if (!this.isVisible()) {
            return;
        }
        this.updateCursorAlpha();
        if (!this.method_25370() && this.text.isBlank()) {
            String key = "rso.search_bar_empty";
            class_5250 emptyText = class_2561.method_43471((String)key);
            if (emptyText.getString().equals(key)) {
                emptyText = class_2561.method_43470((String)"Search options...");
            }
            this.drawString(guiGraphics, (class_2561)emptyText, this.dim.x() + 6, this.dim.y() + 6, -5592406);
        }
        this.drawRect(guiGraphics, this.dim.x(), this.dim.y(), this.dim.getLimitX(), this.dim.getLimitY(), this.method_25370() ? -536870912 : -1879048192);
        int selectionStartOffset = this.selectionStart - this.firstCharacterIndex;
        int selectionEndOffset = this.selectionEnd - this.firstCharacterIndex;
        String displayedText = this.font.method_27523(this.text.substring(this.firstCharacterIndex), this.getInnerWidth());
        boolean isCursorWithinDisplayedText = selectionStartOffset >= 0 && selectionStartOffset <= displayedText.length();
        int textStartX = this.dim.x() + 6;
        int textStartY = this.dim.y() + 6;
        int textEndX = textStartX;
        if (selectionEndOffset > displayedText.length()) {
            selectionEndOffset = displayedText.length();
        }
        if (!displayedText.isEmpty()) {
            String preCursorText = isCursorWithinDisplayedText ? displayedText.substring(0, selectionStartOffset) : displayedText;
            guiGraphics.method_35720(this.font, this.renderTextProvider.apply(preCursorText, this.firstCharacterIndex), textEndX, textStartY, -1);
            textEndX += this.font.method_30880(this.renderTextProvider.apply(preCursorText, this.firstCharacterIndex));
        }
        boolean isCursorAtEnd = this.selectionStart < this.text.length() || this.text.length() >= this.getMaxLength();
        int cursorX = textEndX;
        if (!isCursorWithinDisplayedText) {
            cursorX = selectionStartOffset > 0 ? textStartX + this.dim.width() - 12 : textStartX;
        } else if (isCursorAtEnd) {
            --cursorX;
            --textEndX;
        }
        if (!displayedText.isEmpty() && isCursorWithinDisplayedText && selectionStartOffset < displayedText.length()) {
            guiGraphics.method_35720(this.font, this.renderTextProvider.apply(displayedText.substring(selectionStartOffset), this.selectionStart), textEndX, textStartY, -1);
        }
        if (this.method_25370()) {
            int color = (int)(this.currentCursorAlpha * 255.0f) << 24 | 0xD0D0D0;
            Objects.requireNonNull(this.font);
            guiGraphics.method_48196(class_10799.field_56879, cursorX, textStartY - 1, cursorX + 1, textStartY + 1 + 9, color);
        }
        if (selectionEndOffset != selectionStartOffset) {
            int selectionEndX = textStartX + this.font.method_1727(displayedText.substring(0, selectionEndOffset));
            Objects.requireNonNull(this.font);
            this.drawSelectionHighlight(guiGraphics, cursorX, textStartY - 1, selectionEndX - 1, textStartY + 1 + 9);
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        int clickX = class_3532.method_15357((double)mouseX) - this.dim.x() - 6;
        String displayedText = this.font.method_27523(this.text.substring(this.firstCharacterIndex), this.getInnerWidth());
        this.setCursor(this.font.method_27523(displayedText, clickX).length() + this.firstCharacterIndex);
        this.method_25365(this.dim.containsCursor(mouseX, mouseY));
        this.pages.forEach(page -> page.getOptions().stream().filter(OptionExtended.class::isInstance).map(OptionExtended.class::cast).forEach(optionExtended -> optionExtended.setSelected(false)));
        return this.method_25370();
    }

    public void method_25365(boolean focused) {
        this.focused = focused;
    }

    public boolean method_25405(double x, double y) {
        return this.dim.containsCursor(x, y);
    }

    private void drawSelectionHighlight(class_332 guiGraphics, int startX, int startY, int endX, int endY) {
        int temp;
        if (startX < endX) {
            temp = startX;
            startX = endX;
            endX = temp;
        }
        if (startY < endY) {
            temp = startY;
            startY = endY;
            endY = temp;
        }
        if (endX > this.dim.x() + this.dim.width()) {
            endX = this.dim.x() + this.dim.width();
        }
        if (startX > this.dim.x() + this.dim.width()) {
            startX = this.dim.x() + this.dim.width();
        }
        guiGraphics.method_48196(class_10799.field_56881, startX, startY, endX, endY, -16776961);
    }

    private int getMaxLength() {
        return this.maxLength;
    }

    public String getSelectedText() {
        int selectionStartIndex = Math.min(this.selectionStart, this.selectionEnd);
        int selectionEndIndex = Math.max(this.selectionStart, this.selectionEnd);
        return this.text.substring(selectionStartIndex, selectionEndIndex);
    }

    public void write(String text) {
        String beforeSelectionText;
        String filteredText;
        int filteredTextLength;
        int selectionStartIndex = Math.min(this.selectionStart, this.selectionEnd);
        int selectionEndIndex = Math.max(this.selectionStart, this.selectionEnd);
        int availableSpace = this.maxLength - this.text.length() - (selectionStartIndex - selectionEndIndex);
        if (availableSpace < (filteredTextLength = (filteredText = class_3544.method_57180((String)text)).length())) {
            filteredText = filteredText.substring(0, availableSpace);
            filteredTextLength = availableSpace;
        }
        if (this.textPredicate.test(beforeSelectionText = new StringBuilder(this.text).replace(selectionStartIndex, selectionEndIndex, filteredText).toString())) {
            this.currentCursorState = true;
            this.nextCursorUpdate = System.currentTimeMillis() + 750L;
            this.text = beforeSelectionText;
            this.setSelectionStart(selectionStartIndex + filteredTextLength);
            this.setSelectionEnd(this.selectionStart);
            this.onChanged(this.text);
        }
    }

    private void onChanged(String query) {
        this.pages.forEach(page -> page.getOptions().stream().filter(OptionExtended.class::isInstance).map(OptionExtended.class::cast).forEach(optionExtended -> optionExtended.setHighlight(false)));
        this.lastSearch.set(query.trim());
        if (this.editable && !query.trim().isEmpty()) {
            List<Option> searchResults = StringUtils.searchElements(() -> this.pages.stream().flatMap(p -> p.getOptions().stream()).iterator(), query, o -> String.format("%s %s", o.getName().getString(), o.getTooltip().getString()));
            searchResults.stream().filter(OptionExtended.class::isInstance).map(OptionExtended.class::cast).forEach(optionExtended -> optionExtended.setHighlight(true));
        }
    }

    private void erase(int offset) {
        if (class_437.method_25441()) {
            this.eraseWords(offset);
        } else {
            this.eraseCharacters(offset);
        }
    }

    public void eraseWords(int wordOffset) {
        if (!this.text.isEmpty()) {
            if (this.selectionEnd != this.selectionStart) {
                this.write("");
            } else {
                this.eraseCharacters(this.getWordSkipPosition(wordOffset) - this.selectionStart);
            }
        }
    }

    public void eraseCharacters(int characterOffset) {
        if (!this.text.isEmpty()) {
            if (this.selectionEnd != this.selectionStart) {
                this.write("");
            } else {
                String newText;
                int endIndex;
                int cursorPosWithOffset = this.getCursorPosWithOffset(characterOffset);
                int startIndex = Math.min(cursorPosWithOffset, this.selectionStart);
                if (startIndex != (endIndex = Math.max(cursorPosWithOffset, this.selectionStart)) && this.textPredicate.test(newText = new StringBuilder(this.text).delete(startIndex, endIndex).toString())) {
                    this.text = newText;
                    this.setCursor(startIndex);
                    this.onChanged(this.text);
                }
            }
        }
    }

    public int getWordSkipPosition(int wordOffset) {
        return this.getWordSkipPosition(wordOffset, this.getCursor());
    }

    private int getWordSkipPosition(int wordOffset, int cursorPosition) {
        return this.getWordSkipPosition(wordOffset, cursorPosition, true);
    }

    private int getWordSkipPosition(int wordOffset, int cursorPosition, boolean skipOverSpaces) {
        int newPosition = cursorPosition;
        boolean isNegativeOffset = wordOffset < 0;
        int absoluteOffset = Math.abs(wordOffset);
        for (int i = 0; i < absoluteOffset; ++i) {
            if (!isNegativeOffset) {
                int textLength = this.text.length();
                if ((newPosition = this.text.indexOf(32, newPosition)) == -1) {
                    newPosition = textLength;
                    continue;
                }
                while (skipOverSpaces && newPosition < textLength && this.text.charAt(newPosition) == ' ') {
                    ++newPosition;
                }
                continue;
            }
            while (skipOverSpaces && newPosition > 0 && this.text.charAt(newPosition - 1) == ' ') {
                --newPosition;
            }
            while (newPosition > 0 && this.text.charAt(newPosition - 1) != ' ') {
                --newPosition;
            }
        }
        return newPosition;
    }

    public int getCursor() {
        return this.selectionStart;
    }

    public void setCursor(int cursor) {
        this.setSelectionStart(cursor);
        if (!this.selecting) {
            this.setSelectionEnd(this.selectionStart);
        }
        this.onChanged(this.text);
    }

    public void moveCursor(int offset) {
        this.setCursor(this.getCursorPosWithOffset(offset));
    }

    private int getCursorPosWithOffset(int offset) {
        return class_156.method_27761((String)this.text, (int)this.selectionStart, (int)offset);
    }

    public void setSelectionStart(int cursor) {
        this.selectionStart = class_3532.method_15340((int)cursor, (int)0, (int)this.text.length());
    }

    public void setCursorToStart() {
        this.setCursor(0);
    }

    public void setCursorToEnd() {
        this.setCursor(this.text.length());
    }

    public void setSelectionEnd(int index) {
        int textLength = this.text.length();
        this.selectionEnd = class_3532.method_15340((int)index, (int)0, (int)textLength);
        if (this.firstCharacterIndex > textLength) {
            this.firstCharacterIndex = textLength;
        }
        int innerWidth = this.getInnerWidth();
        String displayText = this.font.method_27523(this.text.substring(this.firstCharacterIndex), innerWidth);
        int endIndex = displayText.length() + this.firstCharacterIndex;
        if (this.selectionEnd == this.firstCharacterIndex) {
            this.firstCharacterIndex -= this.font.method_27524(this.text, innerWidth, true).length();
        }
        if (this.selectionEnd > endIndex) {
            this.firstCharacterIndex += this.selectionEnd - endIndex;
        } else if (this.selectionEnd <= this.firstCharacterIndex) {
            this.firstCharacterIndex -= this.firstCharacterIndex - this.selectionEnd;
        }
        this.firstCharacterIndex = class_3532.method_15340((int)this.firstCharacterIndex, (int)0, (int)textLength);
    }

    public boolean method_37303() {
        return this.isVisible() && this.method_25370() && this.isEditable();
    }

    public boolean method_25400(char chr, int modifiers) {
        if (!this.method_37303()) {
            return false;
        }
        if (class_3544.method_57175((char)chr)) {
            if (this.editable) {
                this.lastSearch.set(this.text.trim());
                this.write(Character.toString(chr));
                this.lastSearchIndex.set(0);
            }
            return true;
        }
        return false;
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        this.pages.forEach(page -> page.getOptions().stream().filter(OptionExtended.class::isInstance).map(OptionExtended.class::cast).forEach(optionExtended -> optionExtended.setSelected(false)));
        if (!this.method_37303()) {
            return false;
        }
        this.selecting = class_437.method_25442();
        if (class_437.method_25439((int)keyCode)) {
            this.setCursorToEnd();
            this.setSelectionEnd(0);
            return true;
        }
        if (class_437.method_25438((int)keyCode)) {
            class_310.method_1551().field_1774.method_1455(this.getSelectedText());
            return true;
        }
        if (class_437.method_25437((int)keyCode)) {
            if (this.editable) {
                this.write(class_310.method_1551().field_1774.method_1460());
            }
            return true;
        }
        if (class_437.method_25436((int)keyCode)) {
            class_310.method_1551().field_1774.method_1455(this.getSelectedText());
            if (this.editable) {
                this.write("");
            }
            return true;
        }
        switch (keyCode) {
            case 257: {
                if (this.editable) {
                    int count = 0;
                    for (OptionPage page3 : this.pages) {
                        for (Option option : page3.getOptions()) {
                            OptionExtended optionExtended;
                            if (!(option instanceof OptionExtended) || !(optionExtended = (OptionExtended)option).isHighlight() || optionExtended.getParentDimension() == null) continue;
                            if (count == this.lastSearchIndex.get()) {
                                Dim2i optionDim = optionExtended.getDim2i();
                                Dim2i parentDim = optionExtended.getParentDimension();
                                int maxOffset = parentDim.height() - this.tabDimHeight;
                                int input = optionDim.y() - parentDim.y();
                                int inputOffset = input + optionDim.height() == parentDim.height() ? parentDim.height() : input;
                                int offset = inputOffset * maxOffset / parentDim.height();
                                int total = this.pages.stream().mapToInt(page2 -> Math.toIntExact(page2.getOptions().stream().filter(OptionExtended.class::isInstance).map(OptionExtended.class::cast).filter(OptionExtended::isHighlight).count())).sum();
                                int value = total == this.lastSearchIndex.get() + 1 ? 0 : this.lastSearchIndex.get() + 1;
                                optionExtended.setSelected(true);
                                this.lastSearchIndex.set(value);
                                this.tabFrameSelectedTab.set(page3.getName());
                                this.tabFrameScrollBarOffset.set(0);
                                this.optionPageScrollBarOffset.set(offset);
                                this.method_25365(false);
                                this.sodiumVideoOptionsScreen.rebuildUI();
                                return true;
                            }
                            ++count;
                        }
                    }
                }
                return true;
            }
            case 259: {
                if (this.editable) {
                    this.selecting = false;
                    this.erase(-1);
                    this.selecting = class_437.method_25442();
                }
                return true;
            }
            case 261: {
                if (this.editable) {
                    this.selecting = false;
                    this.erase(1);
                    this.selecting = class_437.method_25442();
                }
                return true;
            }
            case 262: {
                if (class_437.method_25441()) {
                    this.setCursor(this.getWordSkipPosition(1));
                } else {
                    this.moveCursor(1);
                }
                boolean state = this.getCursor() != this.lastCursorPosition && this.getCursor() != this.text.length() + 1;
                this.lastCursorPosition = this.getCursor();
                return state;
            }
            case 263: {
                if (class_437.method_25441()) {
                    this.setCursor(this.getWordSkipPosition(-1));
                } else {
                    this.moveCursor(-1);
                }
                boolean state = this.getCursor() != this.lastCursorPosition && this.getCursor() != 0;
                this.lastCursorPosition = this.getCursor();
                return state;
            }
            case 268: {
                this.setCursorToStart();
                return true;
            }
            case 269: {
                this.setCursorToEnd();
                return true;
            }
        }
        return false;
    }

    private void updateCursorAlpha() {
        float cursorAlpha;
        long currentTimeMillis = System.currentTimeMillis();
        if (currentTimeMillis >= this.nextCursorUpdate) {
            this.currentCursorState = !this.currentCursorState;
            this.nextCursorUpdate = currentTimeMillis + 750L;
        }
        cursorAlpha = (cursorAlpha = (float)(this.nextCursorUpdate - currentTimeMillis) / 750.0f) <= 0.25f ? (cursorAlpha *= 4.0f) : (cursorAlpha >= 0.75f ? (1.0f - cursorAlpha) * 4.0f : 1.0f);
        cursorAlpha = Math.clamp(cursorAlpha, 0.0f, 1.0f);
        this.currentCursorAlpha = this.currentCursorState ? 1.0f : 1.0f - cursorAlpha;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public int getInnerWidth() {
        return this.dim.width() - 12;
    }

    @Nullable
    public class_8016 method_48205(class_8023 navigation) {
        if (!this.visible) {
            return null;
        }
        return super.method_48205(navigation);
    }

    @NotNull
    public class_8030 method_48202() {
        return new class_8030(this.dim.x(), this.dim.y(), this.dim.width(), this.dim.height());
    }
}

