/*
 * Decompiled with CFR 0.152.
 */
package net.uku3lig.ukulib.config.screen;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_7919;
import net.uku3lig.ukulib.config.ConfigManager;
import net.uku3lig.ukulib.config.impl.BrokenConfigScreen;
import net.uku3lig.ukulib.config.screen.CloseableScreen;
import net.uku3lig.ukulib.utils.Ukutils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseConfigScreen<T extends Serializable>
extends CloseableScreen {
    protected final ConfigManager<T> manager;
    protected final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private class_4185 doneButton;

    protected BaseConfigScreen(String key, class_437 parent, ConfigManager<T> manager) {
        super(key, parent);
        this.manager = manager;
    }

    protected <R> R applyConfigChecked(Function<T, R> mapper, R defaultValue) {
        try {
            return mapper.apply(this.manager.getConfig());
        }
        catch (Exception e) {
            this.log.error("Error while getting options, replacing config with the default one", (Throwable)e);
            this.manager.resetConfig();
            try {
                return mapper.apply(this.manager.getConfig());
            }
            catch (Exception e2) {
                this.log.error("Error while getting options with the default config, this is a bug", (Throwable)e2);
                class_310.method_1551().method_1507((class_437)new BrokenConfigScreen(this.parent));
                return defaultValue;
            }
        }
    }

    protected void method_25426() {
        this.doneButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_5244.field_24334, button -> class_310.method_1551().method_1507(this.parent)).method_46434(this.field_22789 / 2 - 155, this.field_22790 - 27, 150, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"ukulib.option.reset"), button -> {
            class_310.method_1551().method_1507(this.parent);
            this.manager.resetConfig();
            this.manager.saveConfig();
            Ukutils.sendToast(class_2561.method_30163((String)"Sucessfully reset config!"), null);
        }).method_46434(this.field_22789 / 2 + 5, this.field_22790 - 27, 150, 20).method_46431());
    }

    public void method_25393() {
        super.method_25393();
        Collection<class_339> invalid = this.getInvalidOptions();
        this.doneButton.field_22763 = invalid.isEmpty();
        if (this.doneButton.field_22763) {
            this.doneButton.method_47400(class_7919.method_47407((class_2561)class_2561.method_43473()));
        } else {
            String invalidNames = invalid.stream().map(class_339::method_25369).map(class_2561::getString).collect(Collectors.joining(", "));
            this.doneButton.method_47400(class_7919.method_47407((class_2561)class_2561.method_43469((String)"ukulib.option.invalid", (Object[])new Object[]{invalidNames})));
        }
    }

    protected Collection<class_339> getInvalidOptions() {
        return Collections.emptyList();
    }

    public void method_25432() {
        if (this.getInvalidOptions().isEmpty()) {
            this.manager.saveConfig();
        }
    }
}

