/*
 * Decompiled with CFR 0.152.
 */
package net.uku3lig.ukulib.config.option.widget;

import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import lombok.Generated;
import net.minecraft.class_10799;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3532;
import net.minecraft.class_4068;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5481;
import net.minecraft.class_6381;
import net.minecraft.class_6382;
import net.minecraft.class_7919;
import net.minecraft.class_8016;
import net.minecraft.class_8023;
import net.uku3lig.ukulib.config.option.CheckedOption;
import org.jetbrains.annotations.Nullable;

public class TextInputWidget
extends class_339
implements class_4068,
CheckedOption {
    private static final int VERTICAL_CURSOR_COLOR = -3092272;
    private static final String HORIZONTAL_CURSOR = "_";
    private static final int TEXT_COLOR = -2039584;
    private static final int BORDER_COLOR = -6250336;
    private static final int BACKGROUND_COLOR = -16777216;
    private static final int ERROR_COLOR = -65536;
    private final class_327 textRenderer;
    private String text;
    private boolean selecting;
    private int firstCharacterIndex;
    private int selectionStart;
    private int selectionEnd;
    private final int maxLength;
    private final String suggestion;
    private final Consumer<String> changedListener;
    private final Predicate<String> textPredicate;
    private final BiFunction<String, Integer, class_5481> renderTextProvider;

    public TextInputWidget(int x, int y, int width, int height, String initialValue, Consumer<String> changedListener, String suggestion, Predicate<String> textPredicate, int maxLength) {
        super(x, y, width, height, class_2561.method_30163((String)suggestion));
        this.textRenderer = class_310.method_1551().field_1772;
        this.text = "";
        this.renderTextProvider = (string, index) -> class_5481.method_30747((String)string, (class_2583)class_2583.field_24360);
        this.changedListener = changedListener;
        this.suggestion = suggestion;
        this.textPredicate = textPredicate;
        this.maxLength = maxLength;
        this.setText(initialValue);
        this.method_47400(class_7919.method_47407((class_2561)class_2561.method_30163((String)this.suggestion)));
    }

    protected class_5250 method_25360() {
        class_2561 message = this.method_25369();
        return class_2561.method_43469((String)"gui.narrate.editBox", (Object[])new Object[]{message, this.text});
    }

    public void setText(String text) {
        this.text = text.length() > this.maxLength ? text.substring(0, this.maxLength) : text;
        this.setCursorToEnd();
        this.setSelectionEnd(this.selectionStart);
        this.onChanged(text);
    }

    public String getSelectedText() {
        int i = Math.min(this.selectionStart, this.selectionEnd);
        int j = Math.max(this.selectionStart, this.selectionEnd);
        return this.text.substring(i, j);
    }

    public void write(String text) {
        int l;
        int i = Math.min(this.selectionStart, this.selectionEnd);
        int j = Math.max(this.selectionStart, this.selectionEnd);
        int k = this.maxLength - this.text.length() - (i - j);
        if (k < (l = text.length())) {
            text = text.substring(0, k);
            l = k;
        }
        this.text = new StringBuilder(this.text).replace(i, j, text).toString();
        this.setSelectionStart(i + l);
        this.setSelectionEnd(this.selectionStart);
        this.onChanged(this.text);
    }

    private void onChanged(String newText) {
        if (this.textPredicate.test(newText)) {
            this.changedListener.accept(newText);
        }
    }

    private void erase(int offset) {
        if (class_437.method_25441()) {
            this.eraseWords(offset);
        } else {
            this.eraseCharacters(offset);
        }
    }

    public void eraseWords(int wordOffset) {
        if (!this.text.isEmpty()) {
            if (this.selectionEnd != this.selectionStart) {
                this.write("");
            } else {
                this.eraseCharacters(this.getWordSkipPosition(wordOffset) - this.selectionStart);
            }
        }
    }

    public void eraseCharacters(int characterOffset) {
        if (!this.text.isEmpty()) {
            if (this.selectionEnd != this.selectionStart) {
                this.write("");
            } else {
                int k;
                int i = this.getCursorPosWithOffset(characterOffset);
                int j = Math.min(i, this.selectionStart);
                if (j != (k = Math.max(i, this.selectionStart))) {
                    this.text = new StringBuilder(this.text).delete(j, k).toString();
                    this.setCursor(j);
                }
            }
        }
    }

    public int getWordSkipPosition(int wordOffset) {
        return this.getWordSkipPosition(wordOffset, this.getCursor());
    }

    private int getWordSkipPosition(int wordOffset, int cursorPosition) {
        int i = cursorPosition;
        boolean bl = wordOffset < 0;
        int j = Math.abs(wordOffset);
        for (int k = 0; k < j; ++k) {
            if (!bl) {
                int l = this.text.length();
                if ((i = this.text.indexOf(32, i)) == -1) {
                    i = l;
                    continue;
                }
                while (i < l && this.text.charAt(i) == ' ') {
                    ++i;
                }
                continue;
            }
            while (i > 0 && this.text.charAt(i - 1) == ' ') {
                --i;
            }
            while (i > 0 && this.text.charAt(i - 1) != ' ') {
                --i;
            }
        }
        return i;
    }

    public void moveCursor(int offset) {
        this.setCursor(this.getCursorPosWithOffset(offset));
    }

    private int getCursorPosWithOffset(int offset) {
        return class_156.method_27761((String)this.text, (int)this.selectionStart, (int)offset);
    }

    public void setCursor(int cursor) {
        this.setSelectionStart(cursor);
        if (!this.selecting) {
            this.setSelectionEnd(this.selectionStart);
        }
        this.onChanged(this.text);
    }

    public void setSelectionStart(int cursor) {
        this.selectionStart = class_3532.method_15340((int)cursor, (int)0, (int)this.text.length());
    }

    public void setCursorToStart() {
        this.setCursor(0);
    }

    public void setCursorToEnd() {
        this.setCursor(this.text.length());
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (this.isInactive()) {
            return false;
        }
        this.selecting = class_437.method_25442();
        if (class_437.method_25439((int)keyCode)) {
            this.setCursorToEnd();
            this.setSelectionEnd(0);
            return true;
        }
        if (class_437.method_25438((int)keyCode)) {
            class_310.method_1551().field_1774.method_1455(this.getSelectedText());
            return true;
        }
        if (class_437.method_25437((int)keyCode)) {
            this.write(class_310.method_1551().field_1774.method_1460());
            return true;
        }
        if (class_437.method_25436((int)keyCode)) {
            class_310.method_1551().field_1774.method_1455(this.getSelectedText());
            this.write("");
            return true;
        }
        switch (keyCode) {
            case 259: {
                this.selecting = false;
                this.erase(-1);
                this.selecting = class_437.method_25442();
                return true;
            }
            case 261: {
                this.selecting = false;
                this.erase(1);
                this.selecting = class_437.method_25442();
                return true;
            }
            case 262: {
                if (class_437.method_25441()) {
                    this.setCursor(this.getWordSkipPosition(1));
                } else {
                    this.moveCursor(1);
                }
                return true;
            }
            case 263: {
                if (class_437.method_25441()) {
                    this.setCursor(this.getWordSkipPosition(-1));
                } else {
                    this.moveCursor(-1);
                }
                return true;
            }
            case 268: {
                this.setCursorToStart();
                return true;
            }
            case 269: {
                this.setCursorToEnd();
                return true;
            }
        }
        return false;
    }

    public boolean isInactive() {
        return !this.isVisible() || !this.method_25370();
    }

    public boolean method_25400(char chr, int modifiers) {
        if (this.isInactive()) {
            return false;
        }
        if (chr >= ' ') {
            this.write(Character.toString(chr));
            return true;
        }
        return false;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.isVisible() && button == 0) {
            this.method_25365(this.method_25405(mouseX, mouseY));
            if (this.method_25370()) {
                int i = class_3532.method_15357((double)mouseX) - this.method_46426() - 4;
                String string = this.textRenderer.method_27523(this.text.substring(this.firstCharacterIndex), this.getInnerWidth());
                this.setCursor(this.textRenderer.method_27523(string, i).length() + this.firstCharacterIndex);
                return true;
            }
        }
        return false;
    }

    public void method_48579(class_332 drawContext, int mouseX, int mouseY, float delta) {
        boolean canSuggestionBeRendered;
        int textColor;
        if (!this.isVisible()) {
            return;
        }
        int borderColor = this.method_25370() ? -1 : -6250336;
        drawContext.method_25294(this.method_46426() - 1, this.method_46427() - 1, this.method_46426() + this.field_22758 + 1, this.method_46427() + this.field_22759 + 1, borderColor);
        drawContext.method_25294(this.method_46426(), this.method_46427(), this.method_46426() + this.field_22758, this.method_46427() + this.field_22759, -16777216);
        int cursorStart = this.selectionStart - this.firstCharacterIndex;
        int cursorEnd = this.selectionEnd - this.firstCharacterIndex;
        String string = this.textRenderer.method_27523(this.text.substring(this.firstCharacterIndex), this.getInnerWidth());
        boolean isSelectionInBounds = cursorStart >= 0 && cursorStart <= string.length();
        int textX = this.method_46426() + 4;
        int textY = this.method_46427() + (this.field_22759 - 8) / 2;
        int textEnd = textX;
        if (cursorEnd > string.length()) {
            cursorEnd = string.length();
        }
        int n = textColor = this.isValid() ? -2039584 : -65536;
        if (!string.isEmpty()) {
            String beforeCursor = isSelectionInBounds ? string.substring(0, cursorStart) : string;
            class_5481 orderedText = this.renderTextProvider.apply(beforeCursor, this.firstCharacterIndex);
            drawContext.method_35720(this.textRenderer, orderedText, textX, textY, textColor);
            textEnd += this.textRenderer.method_30880(orderedText) + 1;
        }
        boolean isCursorInTheMiddle = this.selectionStart < this.text.length() || this.text.length() >= this.getMaxLength();
        int cursorX = textEnd;
        if (!isSelectionInBounds) {
            cursorX = cursorStart > 0 ? textX + this.field_22758 : textX;
        } else if (isCursorInTheMiddle) {
            cursorX = textEnd - 1;
            --textEnd;
        }
        if (!string.isEmpty() && isSelectionInBounds && cursorStart < string.length()) {
            drawContext.method_35720(this.textRenderer, this.renderTextProvider.apply(string.substring(cursorStart), this.selectionStart), textEnd, textY, textColor);
        }
        boolean bl = canSuggestionBeRendered = this.textRenderer.method_1727(string + this.suggestion) < this.getInnerWidth();
        if (!this.suggestion.isBlank() && canSuggestionBeRendered) {
            int x = this.method_46426() + this.method_25368() - 4 - this.textRenderer.method_1727(this.suggestion);
            drawContext.method_25303(this.textRenderer, this.suggestion, x, textY, -8355712);
        }
        if (this.method_25370()) {
            if (isCursorInTheMiddle) {
                drawContext.method_25294(cursorX, textY - 1, cursorX + 1, textY + 1 + 9, -3092272);
            } else {
                drawContext.method_25303(this.textRenderer, HORIZONTAL_CURSOR, cursorX, textY, -2039584);
            }
        }
        if (cursorEnd != cursorStart) {
            int p = textX + this.textRenderer.method_1727(string.substring(0, cursorEnd));
            this.drawSelectionHighlight(drawContext, cursorX, textY - 1, p - 1, textY + 1 + 9);
        }
    }

    private void drawSelectionHighlight(class_332 drawContext, int x1, int y1, int x2, int y2) {
        int i;
        if (x1 < x2) {
            i = x1;
            x1 = x2;
            x2 = i;
        }
        if (y1 < y2) {
            i = y1;
            y1 = y2;
            y2 = i;
        }
        if (x2 > this.method_46426() + this.field_22758) {
            x2 = this.method_46426() + this.field_22758;
        }
        if (x1 > this.method_46426() + this.field_22758) {
            x1 = this.method_46426() + this.field_22758;
        }
        drawContext.method_48196(class_10799.field_56881, x1, y1, x2, y2, -16776961);
    }

    public int getCursor() {
        return this.selectionStart;
    }

    @Nullable
    public class_8016 method_48205(class_8023 navigation) {
        return this.field_22764 ? super.method_48205(navigation) : null;
    }

    public boolean method_25405(double mouseX, double mouseY) {
        return this.field_22764 && mouseX >= (double)this.method_46426() && mouseX < (double)(this.method_46426() + this.field_22758) && mouseY >= (double)this.method_46427() && mouseY < (double)(this.method_46427() + this.field_22759);
    }

    public int getInnerWidth() {
        return this.field_22758 - 8;
    }

    public void setSelectionEnd(int index) {
        int i = this.text.length();
        this.selectionEnd = class_3532.method_15340((int)index, (int)0, (int)i);
        if (this.textRenderer != null) {
            if (this.firstCharacterIndex > i) {
                this.firstCharacterIndex = i;
            }
            int j = this.getInnerWidth();
            String string = this.textRenderer.method_27523(this.text.substring(this.firstCharacterIndex), j);
            int k = string.length() + this.firstCharacterIndex;
            if (this.selectionEnd == this.firstCharacterIndex) {
                this.firstCharacterIndex -= this.textRenderer.method_27524(this.text, j, true).length();
            }
            if (this.selectionEnd > k) {
                this.firstCharacterIndex += this.selectionEnd - k;
            } else if (this.selectionEnd <= this.firstCharacterIndex) {
                this.firstCharacterIndex -= this.firstCharacterIndex - this.selectionEnd;
            }
            this.firstCharacterIndex = class_3532.method_15340((int)this.firstCharacterIndex, (int)0, (int)i);
        }
    }

    public boolean isVisible() {
        return this.field_22764;
    }

    public void method_47399(class_6382 builder) {
        builder.method_37034(class_6381.field_33788, (class_2561)this.method_25360());
    }

    @Override
    public boolean isValid() {
        return this.textPredicate.test(this.text);
    }

    @Generated
    public String getText() {
        return this.text;
    }

    @Generated
    public int getMaxLength() {
        return this.maxLength;
    }
}

