/*
 * Decompiled with CFR 0.152.
 */
package net.uku3lig.ukulib.config.impl;

import com.google.gson.Gson;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Objects;
import lombok.Generated;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_407;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5481;
import net.uku3lig.ukulib.config.screen.CloseableScreen;
import net.uku3lig.ukulib.utils.Ukutils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrokenConfigScreen
extends CloseableScreen {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BrokenConfigScreen.class);
    private static final HttpClient HTTP_CLIENT = HttpClient.newHttpClient();
    private static final Gson GSON = new Gson();
    private static final URI API_URL = URI.create("https://api.mclo.gs/1/log");

    public BrokenConfigScreen(class_437 parent) {
        super(class_2561.method_30163((String)"Broken config screen"), parent);
    }

    public void method_25394(class_332 drawContext, int mouseX, int mouseY, float delta) {
        super.method_25394(drawContext, mouseX, mouseY, delta);
        drawContext.method_35719(this.field_22793, class_2561.method_30163((String)"There was an issue with this config screen.").method_30937(), this.field_22789 / 2, 100, -1);
        class_5481 class_54812 = class_2561.method_30163((String)"Please report this issue to the mod author.").method_30937();
        int n = this.field_22789 / 2;
        Objects.requireNonNull(this.field_22793);
        drawContext.method_35719(this.field_22793, class_54812, n, 100 + 9 + 4, -1);
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_30163((String)"Upload logs to mclo.gs"), button -> this.uploadLogs()).method_46434(this.field_22789 / 2 - 100, this.field_22790 - 51, 200, 20).method_46431());
        this.method_37063((class_364)Ukutils.doneButton(this.field_22789, this.field_22790, this.parent));
    }

    private void uploadLogs() {
        String content;
        Path logFile = new File(class_310.method_1551().field_1697, "logs/latest.log").toPath();
        try {
            content = Files.readString(logFile);
        }
        catch (IOException e) {
            log.error("Failed to read log file", (Throwable)e);
            return;
        }
        HttpRequest request = HttpRequest.newBuilder(API_URL).POST(HttpRequest.BodyPublishers.ofString("content=" + content)).header("User-Agent", "uku3lig/ukulib").build();
        HTTP_CLIENT.sendAsync(request, HttpResponse.BodyHandlers.ofString()).thenAccept(res -> {
            APIResponse apiRes = (APIResponse)GSON.fromJson((String)res.body(), APIResponse.class);
            if (apiRes.success && apiRes.url != null) {
                log.info("Uploaded logs to {}", (Object)apiRes.url);
                class_310.method_1551().method_1507((class_437)new class_407(confirmed -> {
                    if (confirmed) {
                        class_156.method_668().method_670(apiRes.url);
                    }
                    this.method_25419();
                }, apiRes.url, true));
            } else {
                log.error("Error while uploading logs to mclo.gs: {}", (Object)apiRes.error);
                Ukutils.sendToast(class_2561.method_30163((String)"Error while uploading logs"), class_2561.method_30163((String)apiRes.error));
            }
        });
    }

    private record APIResponse(boolean success, String id, String url, String error) {
    }
}

