/*
 * Decompiled with CFR 0.152.
 */
package forge.me.thosea.badoptimizations.utils.forge;

import forge.me.thosea.badoptimizations.config.Config;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.neoforged.fml.ModList;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.fml.loading.LoadingModList;
import net.neoforged.fml.loading.moddiscovery.ModInfo;

public final class PlatformMethodsImpl {
    private PlatformMethodsImpl() {
    }

    public static String getVersion() {
        return ModList.get().getModContainerById("badoptimizations").map(mod -> mod.getModInfo().getVersion().toString()).orElse("[unknown version]");
    }

    public static Path getConfigFolder() {
        return FMLPaths.CONFIGDIR.get();
    }

    public static boolean isModLoaded(String id) {
        return LoadingModList.get().getModFileById(id) != null;
    }

    public static InputStream streamConfigTemplate() throws IOException {
        return Files.newInputStream(LoadingModList.get().getModFileById("badoptimizations").getFile().findResource(new String[]{"bo-config-template.txt"}), new OpenOption[0]);
    }

    public static Map<String, List<String>> getModIncompatibilities() {
        HashMap<String, List<String>> result = new HashMap<String, List<String>>(1);
        for (ModInfo mod : LoadingModList.get().getMods()) {
            Map map;
            String id = mod.getModId();
            Optional object = mod.getOwningFile().getConfigElement(new String[]{"badoptimizations:incompatibilities"});
            if (object.isEmpty()) continue;
            Object object2 = object.get();
            if (!(object2 instanceof Map) || !((object2 = PlatformMethodsImpl.castMap(map = (Map)object2).get("options")) instanceof List)) {
                Config.LOGGER.warn("Mod {} specifies invalid BadOptimizations incompatibilities, ignoring", (Object)id);
                Config.LOGGER.warn("TOML is not a map containing a string list named options");
                continue;
            }
            List list = (List)object2;
            ArrayList<String> entries = new ArrayList<String>();
            for (Object element : list) {
                if (!(element instanceof String)) {
                    Config.LOGGER.warn("Mod {} specifies invalid BadOptimizations incompatibilities", (Object)id);
                    Config.LOGGER.warn("TOML options contains non-string value in array");
                    continue;
                }
                String entry = (String)element;
                entries.add(entry);
            }
            result.put(id, entries);
        }
        return result;
    }

    private static <T extends Map<?, ?>> T castMap(Map<?, ?> map) {
        return (T)map;
    }
}

