/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.placeholders.api.parsers.tag;

import eu.pb4.placeholders.api.parsers.tag.TextTag;
import eu.pb4.placeholders.impl.textparser.tagreg.SimpleTagRegistry;
import eu.pb4.placeholders.impl.textparser.tagreg.WrappingTagRegistry;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public interface TagRegistry {
    public static final TagRegistry DEFAULT = SimpleTagRegistry.DEFAULT;
    public static final TagRegistry SAFE = SimpleTagRegistry.SAFE;

    public static TagRegistry create() {
        return new SimpleTagRegistry(false);
    }

    public static Builder builder() {
        return new Builder(TagRegistry.create());
    }

    public static TagRegistry copyDefault() {
        return DEFAULT.copy();
    }

    public static Builder builderCopyDefault() {
        return new Builder(TagRegistry.copyDefault());
    }

    public static TagRegistry copySafe() {
        return SAFE.copy();
    }

    public static Builder builderCopySafe() {
        return new Builder(TagRegistry.copySafe());
    }

    public static TagRegistry createDefault() {
        return WrappingTagRegistry.of(DEFAULT);
    }

    public static Builder builderWithDefault() {
        return new Builder(TagRegistry.createDefault());
    }

    public static TagRegistry createSafe() {
        return WrappingTagRegistry.of(SAFE);
    }

    public static Builder builderWithSafe() {
        return new Builder(TagRegistry.createSafe());
    }

    public static void registerDefault(TextTag tag) {
        SimpleTagRegistry.DEFAULT.register(tag);
        if (tag.userSafe()) {
            SimpleTagRegistry.SAFE.register(tag);
        }
    }

    public void register(TextTag var1);

    public void remove(TextTag var1);

    public TagRegistry copy();

    @Nullable
    public TextTag getTag(String var1);

    public List<TextTag> getTags();

    public boolean isGlobal();

    public static final class Builder {
        private final TagRegistry registry;

        Builder(TagRegistry tagRegistry) {
            this.registry = tagRegistry;
        }

        public Builder add(TextTag tag) {
            this.registry.register(tag);
            return this;
        }

        public Builder remove(TextTag tag) {
            this.registry.remove(tag);
            return this;
        }

        public Builder remove(String tag) {
            this.registry.remove(this.registry.getTag(tag));
            return this;
        }

        public Builder copy(TagRegistry registry) {
            registry.getTags().forEach(this.registry::register);
            return this;
        }

        public TagRegistry build() {
            return this.registry;
        }
    }
}

