/*
 * Decompiled with CFR 0.152.
 */
package com.provismet.tooltipscroll;

import com.provismet.tooltipscroll.Options;
import com.provismet.tooltipscroll.OrderedTextReader;
import com.provismet.tooltipscroll.TooltipScrollClient;
import com.provismet.tooltipscroll.mixin.KeyBindAccessor;
import com.provismet.tooltipscroll.mixin.OrderedTextTooltipComponentAccessor;
import java.util.List;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3675;
import net.minecraft.class_5683;
import net.minecraft.class_5684;
import org.apache.commons.lang3.mutable.MutableDouble;

public class ScrollTracker {
    private static double currentXOffset = 0.0;
    private static double currentYOffset = 0.0;
    private static double trueXOffset = 0.0;
    private static double trueYOffset = 0.0;
    private static List<class_5684> currentItem;
    private static long unlockTime;
    private static final long RELOCK_AT = 100L;
    public static int scrollSize;
    public static int scrollSizeKeyboard;
    public static double smoothnessModifier;

    public static void update() {
        currentXOffset += (trueXOffset - currentXOffset) * smoothnessModifier;
        currentYOffset += (trueYOffset - currentYOffset) * smoothnessModifier;
        long mcHandle = class_310.method_1551().method_22683().method_4490();
        int up = ((KeyBindAccessor)TooltipScrollClient.moveUp).getBoundKey().method_1444();
        int down = ((KeyBindAccessor)TooltipScrollClient.moveDown).getBoundKey().method_1444();
        int horizontal = ((KeyBindAccessor)TooltipScrollClient.horizontal).getBoundKey().method_1444();
        int reset = ((KeyBindAccessor)TooltipScrollClient.reset).getBoundKey().method_1444();
        if (Options.useWASD) {
            if (class_3675.method_15987((long)mcHandle, (int)87)) {
                ScrollTracker.scrollUp(scrollSizeKeyboard);
            } else if (class_3675.method_15987((long)mcHandle, (int)83)) {
                ScrollTracker.scrollDown(scrollSizeKeyboard);
            }
            if (class_3675.method_15987((long)mcHandle, (int)65)) {
                ScrollTracker.scrollLeft(scrollSizeKeyboard);
            } else if (class_3675.method_15987((long)mcHandle, (int)68)) {
                ScrollTracker.scrollRight(scrollSizeKeyboard);
            }
        }
        if (up != -1 && class_3675.method_15987((long)mcHandle, (int)up)) {
            if (horizontal != -1 && class_3675.method_15987((long)mcHandle, (int)horizontal) || Options.useLShift && class_3675.method_15987((long)mcHandle, (int)340)) {
                ScrollTracker.scrollLeft(scrollSizeKeyboard);
            } else {
                ScrollTracker.scrollUp(scrollSizeKeyboard);
            }
        } else if (down != -1 && class_3675.method_15987((long)mcHandle, (int)down)) {
            if (horizontal != -1 && class_3675.method_15987((long)mcHandle, (int)horizontal) || Options.useLShift && class_3675.method_15987((long)mcHandle, (int)340)) {
                ScrollTracker.scrollRight(scrollSizeKeyboard);
            } else {
                ScrollTracker.scrollDown(scrollSizeKeyboard);
            }
        } else if (reset != -1 && class_3675.method_15987((long)mcHandle, (int)reset)) {
            ScrollTracker.reset();
        }
    }

    public static int getXOffset() {
        MutableDouble convenientInjectionPoint = new MutableDouble(currentXOffset);
        return class_3532.method_15357((double)convenientInjectionPoint.doubleValue());
    }

    public static int getYOffset() {
        MutableDouble convenientInjectionPoint = new MutableDouble(currentYOffset);
        return class_3532.method_15357((double)convenientInjectionPoint.doubleValue());
    }

    public static void scrollUp() {
        ScrollTracker.scrollUp(scrollSize);
    }

    public static void scrollUp(int amount) {
        if (!ScrollTracker.isLocked()) {
            trueYOffset -= (double)amount;
        }
    }

    public static void scrollDown() {
        ScrollTracker.scrollDown(scrollSize);
    }

    public static void scrollDown(int amount) {
        if (!ScrollTracker.isLocked()) {
            trueYOffset += (double)amount;
        }
    }

    public static void scrollLeft() {
        ScrollTracker.scrollLeft(scrollSize);
    }

    public static void scrollLeft(int amount) {
        if (!ScrollTracker.isLocked()) {
            trueXOffset -= (double)amount;
        }
    }

    public static void scrollRight() {
        ScrollTracker.scrollRight(scrollSize);
    }

    public static void scrollRight(int amount) {
        if (!ScrollTracker.isLocked()) {
            trueXOffset += (double)amount;
        }
    }

    private static void resetScroll() {
        currentXOffset = 0.0;
        currentYOffset = 0.0;
        trueXOffset = 0.0;
        trueYOffset = 0.0;
    }

    private static boolean isEqual(List<class_5684> item1, List<class_5684> item2) {
        if (item1 == null || item2 == null || item1.size() != item2.size()) {
            return false;
        }
        for (int i = 0; i < item1.size(); ++i) {
            String text2;
            if (item1.get(i) instanceof class_5683 && !(item2.get(i) instanceof class_5683)) {
                return false;
            }
            if (item2.get(i) instanceof class_5683 && !(item1.get(i) instanceof class_5683)) {
                return false;
            }
            if (!(item1.get(i) instanceof class_5683) && !(item2.get(i) instanceof class_5683)) continue;
            OrderedTextTooltipComponentAccessor accessible1 = (OrderedTextTooltipComponentAccessor)item1.get(i);
            OrderedTextTooltipComponentAccessor accessible2 = (OrderedTextTooltipComponentAccessor)item2.get(i);
            String text1 = OrderedTextReader.read(accessible1.getText());
            if (text1.equals(text2 = OrderedTextReader.read(accessible2.getText()))) continue;
            return false;
        }
        return true;
    }

    private static boolean isLocked() {
        long difference = System.currentTimeMillis() - unlockTime;
        return difference > 100L;
    }

    public static void reset() {
        ScrollTracker.resetScroll();
        currentItem = null;
    }

    public static void setItem(List<class_5684> item) {
        if (!ScrollTracker.isEqual(currentItem, item)) {
            ScrollTracker.resetScroll();
            currentItem = item;
        }
    }

    public static void unlock() {
        if (Options.resetOnUnlock && ScrollTracker.isLocked()) {
            ScrollTracker.resetScroll();
        }
        unlockTime = System.currentTimeMillis();
    }

    static {
        unlockTime = System.currentTimeMillis();
        scrollSize = 10;
        scrollSizeKeyboard = 5;
        smoothnessModifier = 0.25;
    }
}

