/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.tcdcommons.client.network;

import io.github.thecsdev.tcdcommons.TCDCommons;
import io.github.thecsdev.tcdcommons.api.badge.PlayerBadge;
import io.github.thecsdev.tcdcommons.api.badge.PlayerBadgeHandler;
import io.github.thecsdev.tcdcommons.api.client.badge.ClientPlayerBadge;
import io.github.thecsdev.tcdcommons.api.client.network.PlayerBadgeNetworkListener;
import io.github.thecsdev.tcdcommons.api.hooks.entity.EntityHooks;
import io.github.thecsdev.tcdcommons.api.network.CustomPayloadNetwork;
import io.github.thecsdev.tcdcommons.api.network.CustomPayloadNetworkReceiver;
import io.github.thecsdev.tcdcommons.api.registry.TRegistries;
import io.github.thecsdev.tcdcommons.api.util.collections.GenericProperties;
import io.github.thecsdev.tcdcommons.client.TCDCommonsClient;
import io.netty.buffer.ByteBuf;
import java.util.Objects;
import net.minecraft.class_1297;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_437;
import net.minecraft.class_746;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class TcdcClientPlayNetworkHandler {
    private static final class_2960 CUSTOM_DATA_ID = class_2960.method_60655((String)TCDCommons.getModID(), (String)"client_play_network_handler");
    private final class_746 player;

    private TcdcClientPlayNetworkHandler(class_746 player) throws NullPointerException {
        this.player = Objects.requireNonNull(player);
    }

    public final class_746 getPlayer() {
        return this.player;
    }

    public final void onPlayerBadges(CustomPayloadNetworkReceiver.PacketContext context) {
        class_2540 payload = context.getPacketBuffer();
        PlayerBadgeHandler statHandler = ClientPlayerBadge.getClientPlayerBadgeHandler(this.player);
        int badgeCount = payload.readInt();
        for (int index = 0; index < badgeCount && payload.readableBytes() >= 2; ++index) {
            class_2960 badgeId = payload.method_10810();
            int badgeValue = payload.method_10816();
            @Nullable PlayerBadge badge = TRegistries.PLAYER_BADGE.getValue(badgeId).orElse(null);
            if (badge == null || badge instanceof ClientPlayerBadge) continue;
            statHandler.setValue(badgeId, badgeValue);
        }
        TCDCommonsClient.MC_CLIENT.method_40000(() -> {
            class_437 currentScreen = TCDCommonsClient.MC_CLIENT.field_1755;
            if (currentScreen instanceof PlayerBadgeNetworkListener) {
                PlayerBadgeNetworkListener listener = (PlayerBadgeNetworkListener)currentScreen;
                listener.onPlayerBadgesReady();
            }
        });
    }

    public final void sendCustomPayloadNetwork(class_2960 id, ByteBuf buffer) throws IllegalStateException, NullPointerException {
        Objects.requireNonNull(id);
        Objects.requireNonNull(buffer);
        if (buffer.refCnt() < 1) {
            throw new IllegalStateException("REF_CNT");
        }
        CustomPayloadNetwork.sendC2S(id, buffer);
    }

    public static final TcdcClientPlayNetworkHandler of(class_746 player) throws NullPointerException {
        GenericProperties<class_2960> cd = EntityHooks.getCustomData((class_1297)Objects.requireNonNull(player));
        @Nullable TcdcClientPlayNetworkHandler cpnh = (TcdcClientPlayNetworkHandler)cd.getProperty(CUSTOM_DATA_ID);
        if (cpnh == null) {
            cpnh = new TcdcClientPlayNetworkHandler(player);
            cd.setProperty(CUSTOM_DATA_ID, cpnh);
        }
        return cpnh;
    }
}

