/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.tcdcommons.api.client.gui.util;

import io.github.thecsdev.tcdcommons.api.client.gui.util.TDrawContext;
import java.util.Stack;
import org.jetbrains.annotations.Nullable;

public final class ColorStack
extends Stack<Entry> {
    private static final long serialVersionUID = 2434143149100104895L;
    @Nullable
    private Entry lastCalculation;

    public final Entry push(float r, float g, float b, float a) {
        return this.push(r, g, b, a, BlendMethod.MULTIPLY);
    }

    public final Entry push(float r, float g, float b, float a, BlendMethod blendMethod) {
        return this.push(new Entry(r, g, b, a, blendMethod));
    }

    public final Entry pushAlpha(float alpha) {
        return this.push(1.0f, 1.0f, 1.0f, alpha);
    }

    @Override
    public final Entry push(Entry item) {
        this.lastCalculation = null;
        return super.push(item);
    }

    @Override
    public final synchronized Entry pop() {
        this.lastCalculation = null;
        return (Entry)super.pop();
    }

    public final void apply(TDrawContext pencil) {
        this.calculate().apply(pencil);
    }

    public final Entry calculate() {
        if (this.lastCalculation != null) {
            return this.lastCalculation;
        }
        float red = 1.0f;
        float green = 1.0f;
        float blue = 1.0f;
        float alpha = 1.0f;
        for (Entry entry : this) {
            switch (entry.blendMethod.ordinal()) {
                case 3: {
                    red *= entry.r;
                    green *= entry.g;
                    blue *= entry.b;
                    if (!entry.blendAlpha) break;
                    alpha *= entry.a;
                    break;
                }
                case 1: {
                    red += entry.r;
                    green += entry.g;
                    blue += entry.b;
                    if (!entry.blendAlpha) break;
                    alpha += entry.a;
                    break;
                }
                case 0: {
                    red = entry.r;
                    green = entry.g;
                    blue = entry.b;
                    if (!entry.blendAlpha) break;
                    alpha = entry.a;
                    break;
                }
                case 2: {
                    red -= entry.r;
                    green -= entry.g;
                    blue -= entry.b;
                    if (!entry.blendAlpha) break;
                    alpha -= entry.a;
                    break;
                }
                case 4: {
                    alpha = entry.a;
                    break;
                }
            }
            if (entry.blendAlpha || entry.blendMethod == BlendMethod.SET_ALPHA) continue;
            alpha *= entry.a;
        }
        red = Math.max(0.0f, Math.min(1.0f, red));
        green = Math.max(0.0f, Math.min(1.0f, green));
        blue = Math.max(0.0f, Math.min(1.0f, blue));
        alpha = Math.max(0.0f, Math.min(1.0f, alpha));
        this.lastCalculation = new Entry(red, green, blue, alpha, null);
        return this.lastCalculation;
    }

    public static enum BlendMethod {
        SET,
        ADD,
        SUBTRACT,
        MULTIPLY,
        SET_ALPHA;

    }

    public static final class Entry {
        public final float r;
        public final float g;
        public final float b;
        public final float a;
        @Nullable
        public final BlendMethod blendMethod;
        public final boolean blendAlpha;

        public Entry() {
            this(1.0f, 1.0f, 1.0f, 1.0f);
        }

        public Entry(float r, float g, float b, float a) {
            this(r, g, b, a, BlendMethod.MULTIPLY);
        }

        public Entry(float r, float g, float b, float a, BlendMethod blendMethod) {
            this(r, g, b, a, blendMethod, false);
        }

        public Entry(float r, float g, float b, float a, BlendMethod blendMethod, boolean blendAlpha) {
            this.r = r;
            this.g = g;
            this.b = b;
            this.a = a;
            this.blendMethod = blendMethod;
            this.blendAlpha = blendAlpha;
        }

        public final void apply(TDrawContext pencil) {
            pencil.setShaderColor(this.r, this.g, this.b, this.a);
        }
    }
}

