/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.tcdcommons.api.client.gui.layout;

import io.github.thecsdev.tcdcommons.api.client.gui.TElement;
import io.github.thecsdev.tcdcommons.api.client.gui.TParentElement;
import io.github.thecsdev.tcdcommons.api.client.gui.layout.UILayout;
import io.github.thecsdev.tcdcommons.api.util.annotations.Virtual;
import io.github.thecsdev.tcdcommons.api.util.enumerations.Axis2D;
import io.github.thecsdev.tcdcommons.api.util.enumerations.HorizontalAlignment;
import io.github.thecsdev.tcdcommons.api.util.enumerations.VerticalAlignment;
import io.github.thecsdev.tcdcommons.api.util.math.Tuple4;
import java.util.Objects;

@Virtual
public class UIListLayout
extends UILayout {
    protected Axis2D direction;
    protected HorizontalAlignment horizontalAlignment;
    protected VerticalAlignment verticalAlignment;
    protected int childPadding;

    public UIListLayout(Axis2D direction) throws NullPointerException {
        this(direction, 3);
    }

    public UIListLayout(Axis2D direction, int childPadding) throws NullPointerException {
        this(direction, VerticalAlignment.TOP, HorizontalAlignment.LEFT, childPadding);
    }

    public UIListLayout(Axis2D direction, VerticalAlignment verticalAlignment, HorizontalAlignment horizontalAlignment) throws NullPointerException {
        this(direction, verticalAlignment, horizontalAlignment, 3);
    }

    public UIListLayout(Axis2D direction, VerticalAlignment verticalAlignment, HorizontalAlignment horizontalAlignment, int childPadding) throws NullPointerException {
        this.direction = Objects.requireNonNull(direction);
        this.horizontalAlignment = Objects.requireNonNull(horizontalAlignment);
        this.verticalAlignment = Objects.requireNonNull(verticalAlignment);
        this.childPadding = childPadding;
    }

    @Override
    @Virtual
    public void apply(TParentElement parent) {
        Axis2D direction = this.direction;
        if (parent == null || direction == null) {
            return;
        }
        int sPadding = this.getElementScrollPadding(parent);
        int cPadding = this.childPadding;
        int nextX = parent.getX() + sPadding;
        int nextY = parent.getY() + sPadding;
        for (TElement child : parent.getChildren()) {
            child.setPosition(nextX, nextY, false);
            if (direction == Axis2D.X) {
                nextX = child.getEndX() + cPadding;
                continue;
            }
            if (direction != Axis2D.Y) continue;
            nextY = child.getEndY() + cPadding;
        }
        if (parent.getChildren().size() < 1) {
            return;
        }
        parent.getChildren().updateTopmostChildren();
        int globalMoveX = 0;
        int globalMoveY = 0;
        Tuple4<TElement, TElement, TElement, TElement> pTopmosts = parent.getChildren().getTopmostElements();
        if (direction == Axis2D.X) {
            switch (this.horizontalAlignment) {
                case CENTER: {
                    int left = ((TElement)pTopmosts.Item3).getX() - (parent.getX() + sPadding);
                    int right = ((TElement)pTopmosts.Item4).getEndX() - (parent.getEndX() - sPadding);
                    globalMoveX = (left - right) / 2;
                    break;
                }
                case RIGHT: {
                    int right = ((TElement)pTopmosts.Item4).getEndX();
                    int pEndX = parent.getEndX() - sPadding;
                    globalMoveX = pEndX - right;
                    break;
                }
            }
        } else if (direction == Axis2D.Y) {
            switch (this.verticalAlignment) {
                case CENTER: {
                    int top = ((TElement)pTopmosts.Item1).getY() - (parent.getY() + sPadding);
                    int bottom = ((TElement)pTopmosts.Item2).getEndY() - (parent.getEndY() - sPadding);
                    globalMoveY = (top - bottom) / 2;
                    break;
                }
                case BOTTOM: {
                    int bottom = ((TElement)pTopmosts.Item2).getEndY();
                    int pEndY = parent.getEndY() - sPadding;
                    globalMoveY = pEndY - bottom;
                    break;
                }
            }
        }
        if (globalMoveX != 0 || globalMoveY != 0) {
            for (TElement child : parent.getChildren()) {
                child.move(globalMoveX, globalMoveY);
            }
        }
        block18: for (TElement child : parent.getChildren()) {
            if (direction == Axis2D.X) {
                switch (this.verticalAlignment) {
                    case CENTER: {
                        child.setPosition(child.getX(), parent.getY() + parent.getHeight() / 2 - child.getHeight() / 2, false);
                        continue block18;
                    }
                    case BOTTOM: {
                        child.setPosition(child.getX(), parent.getEndY() - sPadding - child.getHeight(), false);
                        continue block18;
                    }
                }
                continue;
            }
            if (direction != Axis2D.Y) continue;
            switch (this.horizontalAlignment) {
                case CENTER: {
                    child.setPosition(parent.getX() + parent.getWidth() / 2 - child.getWidth() / 2, child.getY(), false);
                    break;
                }
                case RIGHT: {
                    child.setPosition(parent.getEndX() - sPadding - child.getWidth(), child.getY(), false);
                    break;
                }
            }
        }
    }
}

