/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.pe.manager;

import com.llamalad7.mixinextras.sugar.ref.LocalRef;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.client.particle.v1.ParticleFactoryRegistry;
import net.fabricmc.fabric.api.particle.v1.FabricParticleTypes;
import net.lopymine.pe.ParticleEffects;
import net.lopymine.pe.capture.ParticleCaptures;
import net.lopymine.pe.particle.TexturedParticleFactory;
import net.lopymine.pe.utils.ArgbUtils;
import net.lopymine.pe.utils.ListUtils;
import net.lopymine.pe.utils.PEStatusEffect;
import net.lopymine.pe.utils.PEType;
import net.lopymine.pe.utils.StatusEffectUtils;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1842;
import net.minecraft.class_1844;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_2398;
import net.minecraft.class_2400;
import net.minecraft.class_2960;
import net.minecraft.class_6880;
import net.minecraft.class_703;
import net.minecraft.class_7923;
import net.minecraft.class_9381;
import org.jetbrains.annotations.Nullable;

public class ParticleEffectsManager {
    private static final List<class_2394> REGISTERED_PARTICLE_TYPES = new ArrayList<class_2394>();
    private static final Map<Integer, List<class_2394>> COLOR_TO_PARTICLES_MAP = new HashMap<Integer, List<class_2394>>();
    private static final HashMap<class_2394, class_1291> MINECRAFT_EFFECTS_WITH_TEXTURED_PARTICLE = ParticleEffectsManager.getMinecraftEffectWidthTexturedParticles();

    @Nullable
    public static List<class_2394> getParticleEffects(Integer i) {
        return COLOR_TO_PARTICLES_MAP.get(i);
    }

    private static class_2394 registerParticleTypeForEffect(class_1291 statusEffect, class_2960 effectId) {
        class_2394 type = (class_2394)class_2378.method_10230((class_2378)class_7923.field_41180, (class_2960)ParticleEffectsManager.getModEffectId(statusEffect, effectId), (Object)FabricParticleTypes.simple());
        REGISTERED_PARTICLE_TYPES.add(type);
        return type;
    }

    private static class_2960 getModEffectId(class_1291 statusEffect, class_2960 effectId) {
        boolean bl = MINECRAFT_EFFECTS_WITH_TEXTURED_PARTICLE.containsValue(statusEffect);
        return ParticleEffects.id(effectId.method_12832() + (bl ? "_new" : ""));
    }

    public static void onInitialize() {
        class_2960 id;
        class_1291 statusEffect;
        for (class_6880.class_6883 reference : class_7923.field_41174.method_42017().toList()) {
            statusEffect = (class_1291)reference.comp_349();
            id = reference.method_40237().method_29177();
            if (!id.method_12836().equals("minecraft")) continue;
            class_2394 type = ParticleEffectsManager.registerParticleTypeForEffect(statusEffect, id);
            StatusEffectUtils.swapParticle(statusEffect, type);
        }
        for (class_6880.class_6883 reference : class_7923.field_41179.method_42017().toList()) {
            List effects;
            OptionalInt optional;
            class_1842 potion = (class_1842)reference.comp_349();
            id = reference.method_40237().method_29177();
            if (!id.method_12836().equals("minecraft") || (optional = class_1844.method_58111((Iterable)(effects = potion.method_8049()))).isEmpty()) continue;
            int color = ArgbUtils.getColorWithoutAlpha(optional.getAsInt());
            List particleEffects = effects.stream().map(class_1293::method_5579).map(class_6880::comp_349).flatMap(effect -> {
                class_2394 particleEffect = ((PEStatusEffect)effect).particleEffects$getParticleEffect();
                if (particleEffect == null) {
                    ParticleEffects.LOGGER.error("[DEV/Potion Registration] Looks like {} effect with color {} doesn't have textured particle, this shouldn't happen! Skipping it registration.", (Object)color, (Object)effect.method_5560().getString());
                    return Stream.empty();
                }
                return Stream.of(particleEffect);
            }).toList();
            COLOR_TO_PARTICLES_MAP.put(color, particleEffects);
        }
        for (class_6880.class_6883 reference : class_7923.field_41174.method_42017().toList()) {
            statusEffect = (class_1291)reference.comp_349();
            id = reference.method_40237().method_29177();
            if (!id.method_12836().equals("minecraft")) continue;
            int color = ArgbUtils.getColorWithoutAlpha(statusEffect.method_5556());
            class_2394 particleEffect = ((PEStatusEffect)statusEffect).particleEffects$getParticleEffect();
            if (particleEffect == null) {
                ParticleEffects.LOGGER.error("[DEV/Effect Registration] Looks like {} effect with color {} doesn't have textured particle, this shouldn't happen! Skipping its registration.", (Object)color, (Object)statusEffect.method_5560().getString());
                continue;
            }
            List<class_2394> effects = COLOR_TO_PARTICLES_MAP.get(color);
            if (effects != null) {
                if (!ParticleEffects.getConfig().isDebugLogEnabled()) continue;
                ParticleEffects.LOGGER.warn("[DEV/Effect Registration] Found registered effects for color {} from {} effect, skipping its registration. If you just mod user, ignore it.", (Object)color, (Object)statusEffect.method_5560().getString());
                continue;
            }
            COLOR_TO_PARTICLES_MAP.put(color, List.of(particleEffect));
        }
    }

    public static void onInitializeClient() {
        for (class_2394 type : REGISTERED_PARTICLE_TYPES) {
            ParticleFactoryRegistry.getInstance().register((class_2396)((class_2400)type), TexturedParticleFactory::new);
        }
    }

    private static HashMap<class_2394, class_1291> getMinecraftEffectWidthTexturedParticles() {
        HashMap<class_2394, class_1291> map = new HashMap<class_2394, class_1291>();
        map.put((class_2394)class_2398.field_11246, (class_1291)class_1294.field_50120.comp_349());
        map.put((class_2394)class_2398.field_50246, (class_1291)class_1294.field_50119.comp_349());
        map.put((class_2394)class_2398.field_50245, (class_1291)class_1294.field_50121.comp_349());
        map.put((class_2394)class_2398.field_50251, (class_1291)class_1294.field_50116.comp_349());
        map.put((class_2394)class_2398.field_50250, (class_1291)class_1294.field_50117.comp_349());
        map.put((class_2394)class_2398.field_50252, (class_1291)class_1294.field_50118.comp_349());
        return map;
    }

    public static class_1291 getVanillaStatusEffectByStatusEffect(class_2394 parameters) {
        return MINECRAFT_EFFECTS_WITH_TEXTURED_PARTICLE.get(parameters);
    }

    public static void processSplashPotionStageOne(LocalRef<List<class_2394>> localParticleEffects, int color) {
        localParticleEffects.set(null);
        if (!ParticleEffects.getConfig().isModEnabled()) {
            return;
        }
        List<class_2394> list = ParticleEffectsManager.getParticleEffects(ArgbUtils.getColorWithoutAlpha(color));
        if (list == null) {
            return;
        }
        localParticleEffects.set(list);
    }

    public static class_703 processSplashPotionStageTwo(@Nullable class_1937 world, class_2394 original, Function<class_2394, class_703> function, LocalRef<List<class_2394>> localParticleEffects, int color) {
        Supplier<class_703> particleSupplier = () -> (class_703)function.apply(original);
        if (!ParticleEffects.getConfig().isModEnabled()) {
            return ParticleEffectsManager.markDebugData(21, particleSupplier);
        }
        List list = (List)localParticleEffects.get();
        if (list == null) {
            return ParticleEffectsManager.markDebugData(22, particleSupplier);
        }
        if (list.isEmpty()) {
            return ParticleEffectsManager.markDebugData(23, particleSupplier);
        }
        if (world == null) {
            return ParticleEffectsManager.markDebugData(24, particleSupplier);
        }
        class_2394 particleEffect = (class_2394)ListUtils.getRandomElement(list, world.method_8409());
        if (particleEffect == null) {
            return ParticleEffectsManager.markDebugData(25, particleSupplier);
        }
        ((PEType)particleEffect).particleEffects$setColor(color);
        ParticleCaptures.setParticle(particleEffect);
        class_703 apply = function.apply(particleEffect);
        ParticleCaptures.setParticle(null);
        return apply;
    }

    public static class_703 swapParticle(class_1937 world, class_2394 original, Function<class_2394, class_703> function, Supplier<class_703> originalCall, double x, double y, double z) {
        int color;
        if (!ParticleEffects.getConfig().isModEnabled()) {
            return ParticleEffectsManager.markDebugData(10, originalCall);
        }
        if (ParticleCaptures.getParticle() != original) {
            return ParticleEffectsManager.markDebugData(11, originalCall);
        }
        if (original instanceof class_9381) {
            class_9381 effect = (class_9381)original;
            color = effect.field_49910;
        } else {
            class_1291 statusEffect = ParticleEffectsManager.getVanillaStatusEffectByStatusEffect(original);
            int n = color = statusEffect == null ? 0 : ArgbUtils.getColorWithoutAlpha(statusEffect.method_5556());
        }
        if (color == 0) {
            return ParticleEffectsManager.markDebugData(13, originalCall);
        }
        List<class_2394> list = ParticleEffectsManager.getParticleEffects(ArgbUtils.getColorWithoutAlpha(color));
        if (list == null) {
            return ParticleEffectsManager.markDebugData(14, originalCall);
        }
        if (list.isEmpty()) {
            return ParticleEffectsManager.markDebugData(15, originalCall);
        }
        if (world == null) {
            return ParticleEffectsManager.markDebugData(16, originalCall);
        }
        class_2394 particleEffect = ListUtils.getRandomElement(list, world.method_8409());
        if (particleEffect == null) {
            return ParticleEffectsManager.markDebugData(17, originalCall);
        }
        ((PEType)particleEffect).particleEffects$setColor(color);
        return function.apply(particleEffect);
    }

    private static class_703 markDebugData(int data, Supplier<class_703> supplier) {
        ParticleCaptures.setDebugData(data);
        class_703 particle = supplier.get();
        ParticleCaptures.setDebugData(null);
        return particle;
    }
}

