/*
 * Decompiled with CFR 0.152.
 */
package me.contaria.fastquit.mixin;

import com.llamalad7.mixinextras.injector.v2.WrapWithCondition;
import me.contaria.fastquit.FastQuit;
import me.contaria.fastquit.FastQuitConfig;
import me.contaria.fastquit.TextHelper;
import me.contaria.fastquit.WorldInfo;
import net.minecraft.class_1132;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3324;
import net.minecraft.class_368;
import net.minecraft.class_370;
import net.minecraft.class_5250;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={MinecraftServer.class})
public abstract class MinecraftServerMixin {
    @Shadow
    @Final
    private static Logger field_4546;

    @Inject(method={"exit"}, at={@At(value="RETURN")})
    private void fastquit$finishSaving(CallbackInfo ci) {
        MinecraftServerMixin minecraftServerMixin = this;
        if (minecraftServerMixin instanceof class_1132) {
            class_1132 server = (class_1132)minecraftServerMixin;
            WorldInfo info = FastQuit.savingWorlds.remove(server);
            if (info == null) {
                FastQuit.warn("\"" + server.method_27728().method_150() + "\" was not registered in currently saving worlds!");
                return;
            }
            class_5250 description = TextHelper.translatable("fastquit.toast." + (info.deleted ? "deleted" : "description"), server.method_27728().method_150());
            if (FastQuit.CONFIG.showSavingTime != FastQuitConfig.ShowSavingTime.FALSE && !info.deleted) {
                description.method_27693(" (" + info.getTimeSaving() + ")");
            }
            if (FastQuit.CONFIG.showToasts) {
                class_310.method_1551().method_20493(() -> class_310.method_1551().method_1566().method_1999((class_368)new class_370(class_370.class_9037.field_47584, (class_2561)TextHelper.translatable("fastquit.toast.title", new Object[0]), (class_2561)description)));
            }
            FastQuit.log(description.getString());
        }
    }

    @WrapWithCondition(method={"shutdown"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/PlayerManager;saveAllPlayerData()V")})
    private boolean fastquit$cancelPlayerSavingIfDeleted(class_3324 playerManager) {
        if (this.isDeleted()) {
            field_4546.info("Cancelled saving players because level was deleted");
            return false;
        }
        return true;
    }

    @Inject(method={"save"}, at={@At(value="INVOKE", target="Ljava/util/Iterator;next()Ljava/lang/Object;"), @At(value="INVOKE", target="Lnet/minecraft/world/level/storage/LevelStorage$Session;backupLevelDataFile(Lnet/minecraft/registry/DynamicRegistryManager;Lnet/minecraft/world/SaveProperties;Lnet/minecraft/nbt/NbtCompound;)V")}, cancellable=true)
    private void fastquit$cancelSavingIfDeleted(CallbackInfoReturnable<Boolean> cir) {
        if (this.isDeleted()) {
            field_4546.info("Cancelled saving worlds because level was deleted");
            cir.setReturnValue((Object)false);
        }
    }

    @Unique
    private boolean isDeleted() {
        WorldInfo info = FastQuit.savingWorlds.get(this);
        return info != null && info.deleted;
    }
}

